Attribute VB_Name = "CH341DLL"
Option Explicit
' 2004.05.28, 2004.10.20, 2005.01.08, 2005.03.25, 2005.04.28
'****************************************
'**  Copyright  (C)  W.ch  1999-2005   **
'**  Web:  http:'www.winchiphead.com  **
'****************************************
'**  DLL for USB interface chip CH341  **
'**  C, VC5.0                          **
'****************************************
'
' USB߽ӿоƬCH341Ӧòӿڿ V1.6
' Ͼߺ޹˾  : W.ch 2005.04
' CH341-DLL  V1.6
' л: Windows 98/ME, Windows 2000/XP
' support USB chip: CH341, CH341A
' USB => Parallel, I2C, SPI, JTAG ...
'
Public Enum EEPROM_TYPE   ' EEPROMͺŶ
  ID_24C01 = 0
  ID_24C02 = 1
  ID_24C04 = 2
  ID_24C08 = 3
  ID_24C16 = 4
  ID_24C32 = 5
  ID_24C64 = 6
  ID_24C128 = 7
  ID_24C256 = 8
  ID_24C512 = 9
  ID_24C1024 = 10
  ID_24C2048 = 11
  ID_24C4096 = 12
End Enum

Type mUspValue
        mUspValueLow As Byte                  ' 02H ֵֽ
        mUspValueHigh As Byte                 ' 03H ֵֽ
End Type
Type mUspIndex
        mUspIndexLow As Byte                  ' 04H ֽ
        mUspIndexHigh  As Byte                ' 05H ֽ
End Type
Type USB_SETUP_PKT                            ' USBƴĽ׶εṹ
    mUspReqType As Byte                       ' 00H 
    mUspRequest As Byte                       ' 01H 
    mUspValue As mUspValue                    ' 02H-03H ֵ
    mUspIndex As mUspIndex                    ' 04H-05H 
    mLength As Integer                        ' 06H-07H ݽ׶εݳ
End Type

Public Const INVALID_HANDLE_VALUE = -1        '
Public Const mCH341_PACKET_LENGTH = 32           ' CH341ֵ֧ݰĳ
Public Const mCH341_PKT_LEN_SHORT = 8               ' CH341ֵ֧Ķݰĳ

Type WIN32_COMMAND                              'WIN32ӿڽṹ
   mFunction As Long                            'ʱָܴ߹ܵ
                                                'ʱز״̬
   mLength As Long                              'ȡ,غݵĳ
   mBuffer(mCH341_PACKET_LENGTH - 1) As Byte    'ݻ,Ϊ0255B
End Type
Public mWIN32_COMMAND As WIN32_COMMAND

Public Const FILE_DEVICE_UNKNOWN = &H22
Public Const FILE_ANY_ACCESS = 0
Public Const METHOD_BUFFERED = 0
' WIN32Ӧòӿ
Public Const IOCTL_CH341_COMMAND = (FILE_DEVICE_UNKNOWN * (2 ^ 16) + FILE_ANY_ACCESS * 2 ^ 14 + &HF34 * 2 ^ 2 + METHOD_BUFFERED)     ' רýӿ

Const mWIN32_COMMAND_HEAD = 8         ' WIN32ӿڵͷ

Public Const mCH341_MAX_NUMBER = 16              ' ͬʱӵCH341

Public Const mMAX_BUFFER_LENGTH = &H1000              ' ݻ󳤶4096

Public Const mMAX_COMMAND_LENGTH = (mWIN32_COMMAND_HEAD + mMAX_BUFFER_LENGTH)             ' ݳȼṹͷĳ

Public Const mDEFAULT_BUFFER_LEN = &H400              ' ݻĬϳ1024

Public Const mDEFAULT_COMMAND_LEN = (mWIN32_COMMAND_HEAD + mDEFAULT_BUFFER_LEN)       ' Ĭݳȼṹͷĳ


' CH341˵ַ
Public Const mCH341_ENDP_INTER_UP = &H81              ' CH341жϴ˵ĵַ
Public Const mCH341_ENDP_INTER_DOWN = &H1             ' CH341ж´˵ĵַ
Public Const mCH341_ENDP_DATA_UP = &H82              ' CH341ݿϴ˵ĵַ
Public Const mCH341_ENDP_DATA_DOWN = &H2            ' CH341ݿ´˵ĵַ


' 豸ӿṩĹܵ
Public Const mPipeDeviceCtrl = &H4                  ' CH341ۺϿƹܵ
Public Const mPipeInterUp = &H5                       ' CH341жϴܵ
Public Const mPipeDataUp = &H6                         ' CH341ݿϴܵ
Public Const mPipeDataDown = &H7                     ' CH341ݿ´ܵ

' ӦòӿڵĹܴ
Public Const mFuncNoOperation = &H0                  ' ޲
Public Const mFuncGetVersion = &H1                    ' ȡ汾
Public Const mFuncGetConfig = &H2                   ' ȡUSB豸
Public Const mFuncSetTimeout = &H9                    ' USBͨѶʱ
Public Const mFuncSetExclusive = &HB                  ' öռʹ
Public Const mFuncResetDevice = &HC                  ' λUSB豸
Public Const mFuncResetPipe = &HD                     ' λUSBܵ
Public Const mFuncAbortPipe = &HE                      ' ȡUSBܵ

' CH341רõĹܴ
Public Const mFuncSetParaMode = &HF                   ' òģʽ
Public Const mFuncReadData0 = &H10                   ' Ӳڶȡݿ0
Public Const mFuncReadData1 = &H11                   ' Ӳڶȡݿ1
Public Const mFuncWriteData0 = &H12                  ' 򲢿дݿ0
Public Const mFuncWriteData1 = &H13                  ' 򲢿дݿ1
Public Const mFuncWriteRead = &H14                    ' 


' USB豸׼
Public Const mUSB_CLR_FEATURE = &H1
Public Const mUSB_SET_FEATURE = &H3
Public Const mUSB_GET_STATUS = &H0
Public Const mUSB_SET_ADDRESS = &H5
Public Const mUSB_GET_DESCR = &H6
Public Const mUSB_SET_DESCR = &H7
Public Const mUSB_GET_CONFIG = &H8
Public Const mUSB_SET_CONFIG = &H9
Public Const mUSB_GET_INTERF = &HA
Public Const mUSB_SET_INTERF = &HB
Public Const mUSB_SYNC_FRAME = &HC

' CH341ƴĳר
Public Const mCH341_VENDOR_READ = &HC0                ' ͨƴʵֵCH341רö
Public Const mCH341_VENDOR_WRITE = &H40             ' ͨƴʵֵCH341רд

' CH341ƴĳר
Public Const mCH341_PARA_INIT = &HB1                 ' ʼ
Public Const mCH341_I2C_STATUS = &H52                ' ȡI2Cӿڵ״̬
Public Const mCH341_I2C_COMMAND = &H53               ' I2Cӿڵ

' CH341ڲ
Public Const mCH341_PARA_CMD_R0 = &HAC                ' Ӳڶ0
Public Const mCH341_PARA_CMD_R1 = &HAD                ' Ӳڶ1
Public Const mCH341_PARA_CMD_W0 = &HA6               ' 򲢿д0
Public Const mCH341_PARA_CMD_W1 = &HA7                ' 򲢿д1
Public Const mCH341_PARA_CMD_STS = &HA0              ' ȡ״̬

' CH341Aڲ
Public Const mCH341A_CMD_SET_OUTPUT = &HA1           ' ò
Public Const mCH341A_CMD_IO_ADDR = &HA2               ' MEMַд/,ӴֽڿʼΪ
Public Const mCH341A_CMD_SPI_STREAM = &HA8           ' SPIӿڵ,ӴֽڿʼΪ
Public Const mCH341A_CMD_SIO_STREAM = &HA9            ' SIOӿڵ,ӴֽڿʼΪ
Public Const mCH341A_CMD_I2C_STREAM = &HAA            ' I2Cӿڵ,ӴֽڿʼΪI2C
Public Const mCH341A_CMD_UIO_STREAM = &HAB            ' UIOӿڵ,ӴֽڿʼΪ

' CH341Aƴĳר
Public Const mCH341A_BUF_CLEAR = &HB2                 ' δɵ
Public Const mCH341A_I2C_CMD_X = &H54                ' I2Cӿڵ,ִ
Public Const mCH341A_DELAY_MS = &H5E                 ' Ϊλʱָʱ
Public Const mCH341A_GET_VER = &H5F                  ' ȡоƬ汾

Public Const mCH341_EPP_IO_MAX = mCH341_PACKET_LENGTH - 1             ' CH341EPP/MEMʽµζдݿ󳤶
Public Const mCH341A_EPP_IO_MAX = &HFF            ' CH341AEPP/MEMʽµζдݿ󳤶

Public Const mCH341A_CMD_IO_ADDR_W = &H0             ' MEMַд/:д,λ6-λ0Ϊַ,һֽΪд
Public Const mCH341A_CMD_IO_ADDR_R = &H80            ' MEMַд/:,λ6-λ0Ϊַ,һ𷵻

Public Const mCH341A_CMD_I2C_STM_STA = &H74          ' I2Cӿڵ:ʼλ
Public Const mCH341A_CMD_I2C_STM_STO = &H75           ' I2Cӿڵ:ֹͣλ
Public Const mCH341A_CMD_I2C_STM_OUT = &H0           'I2Cӿڵ:,λ5-λ0Ϊ,ֽΪ,0ֻһֽڲӦ
Public Const mCH341A_CMD_I2C_STM_IN = &HC0           ' I2Cӿڵ:,λ5-λ0Ϊ,0ֻһֽڲӦ
'#define     mCH341A_CMD_I2C_STM_MAX ( min( 0x3F, mCH341_PACKET_LENGTH ) )   // I2Cӿڵݵ󳤶
Public Const mCH341A_CMD_I2C_STM_SET = &H60           ' I2Cӿڵ:ò,λ2=SPII/O(0=뵥,1=˫˫),λ1λ0=I2Cٶ(00=,01=׼,10=,11=)
Public Const mCH341A_CMD_I2C_STM_US = &H40           ' I2Cӿڵ:΢Ϊλʱ,λ3-λ0Ϊʱֵ
Public Const mCH341A_CMD_I2C_STM_MS = &H50           ' I2Cӿڵ:Ϊλʱ,λ3-λ0Ϊʱֵ
Public Const mCH341A_CMD_I2C_STM_DLY = &HF           ' I2Cӿڵʱֵ
Public Const mCH341A_CMD_I2C_STM_END = &H0            ' I2Cӿڵ:ǰ

Public Const mCH341A_CMD_UIO_STM_IN = &H0            ' UIOӿڵ:D7-D0
Public Const mCH341A_CMD_UIO_STM_DIR = &H40         ' UIOӿڵ:趨I/OD5-D0,λ5-λ0Ϊ
Public Const mCH341A_CMD_UIO_STM_OUT = &H80           'UIOӿڵ:D5-D0,λ5-λ0Ϊ
Public Const mCH341A_CMD_UIO_STM_US = &HC0            ' UIOӿڵ:΢Ϊλʱ,λ5-λ0Ϊʱֵ
Public Const mCH341A_CMD_UIO_STM_END = &H20           ' UIOӿڵ:ǰ


' CH341ڹģʽ
Public Const mCH341_PARA_MODE_EPP = &H0            ' CH341ڹģʽΪEPPʽ
Public Const mCH341_PARA_MODE_EPP17 = &H0            ' CH341AڹģʽΪEPPʽV1.7
Public Const mCH341_PARA_MODE_EPP19 = &H1            ' CH341AڹģʽΪEPPʽV1.9
Public Const mCH341_PARA_MODE_MEM = &H2               ' CH341ڹģʽΪMEMʽ


' ֱ״̬źŵλ
Public Const mStateBitERR = &H100                     ' ֻ,ERR#״̬,1:ߵƽ,0:͵ƽ
Public Const mStateBitPEMP = &H200                   ' ֻ,PEMP״̬,1:ߵƽ,0:͵ƽ
Public Const mStateBitINT = &H400                     ' ֻ,INT#״̬,1:ߵƽ,0:͵ƽ
Public Const mStateBitSLCT = &H800                  ' ֻ,SLCT״̬,1:ߵƽ,0:͵ƽ
Public Const mStateBitSDA = &H800000              ' ֻ,SDA״̬,1:ߵƽ,0:͵ƽ




Declare Function CH341OpenDevice Lib "CH341DLL.DLL" (ByVal iIndex As Long) As Long
' CH341豸,ؾ,Ч
' iIndex  ָCH341豸,0Ӧһ豸

Declare Sub CH341CloseDevice Lib "CH341DLL.DLL" (ByVal iIndex As Long)
' رCH341豸
' iIndex    ָCH341豸

Declare Function CH341GetVersion Lib "CH341DLL.DLL" () As Long
' DLL汾,ذ汾

Declare Function CH341DriverCommand Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByRef ioCommand As WIN32_COMMAND) As Long
' ֱӴ,򷵻0,򷵻ݳ
' iIndex,  ' ָCH341豸,V1.6DLLҲ豸򿪺ľ
' ioCommand   ṹĵַ
' óڵú󷵻ݳ,Ȼṹ,Ƕ,ݷṹ,
' صݳڲʧʱΪ0,ɹʱΪṹĳ,һֽ,򷵻mWIN32_COMMAND_HEAD+1,
' ṹڵǰ,ֱṩ:ܵŻܴ,ȡݵĳ(ѡ),(ѡ)
' ṹڵú,ֱ𷵻:״̬,ݵĳ(ѡ),
'   ״̬WINDOWSĴ,ԲοNTSTATUS.H,
'   ݵĳָصݳ,ݴĻ,дһΪ0

Declare Function CH341GetDrvVersion Lib "CH341DLL.DLL" () As Long
' 汾,ذ汾,򷵻0

Declare Function CH341ResetDevice Lib "CH341DLL.DLL" (ByVal iIndex As Long) As Boolean
'λUSB豸
' iIndex  ָCH341豸

Declare Function CH341GetDeviceDescr Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByRef oBuffer As Any, ByRef ioLength As Long) As Boolean
' ȡ豸
' iIndex,   ָCH341豸
' oBuffer   ָһ㹻Ļ,ڱ
' ioLength   ָ򳤶ȵԪ,ʱΪ׼ȡĳ,غΪʵʶȡĳ

Declare Function CH341GetConfigDescr Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByRef oBuffer As Any, ByRef ioLength As Long) As Boolean
' ȡ
'  iIndex,    ָCH341豸
'  oBuffer,   ָһ㹻Ļ,ڱ
'  ioLength   ָ򳤶ȵԪ,ʱΪ׼ȡĳ,غΪʵʶȡĳ

Declare Function CH341SetIntRoutine Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByVal iIntRoutine As Long) As Boolean
'趨жϷ
' ָCH341豸
'ָжϷ,ΪNULLȡжϷ,жʱøó
'  sub  mPCH341_INT_ROUTINE  (              жϷ
'             ULONG           iStatus )     ж״̬,
' λ7-λ0ӦCH341D7-D0
' λ8ӦCH341ERR#, λ9ӦCH341PEMP, λ10ӦCH341INT#, λ11ӦCH341SLCT

Declare Function CH341ReadInter Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByRef iStatus As Long) As Boolean
' ȡж
' iIndex,  ָCH341豸
' iStatus   ָһ˫ֵԪ,ڱȡж״̬,
' λ7-λ0ӦCH341D7-D0
'  λ8ӦCH341ERR#, λ9ӦCH341PEMP, λ10ӦCH341INT#, λ11ӦCH341SLCT

Declare Function CH341AbortInter Lib "CH341DLL.DLL" (ByVal iIndex As Long) As Boolean
' жݶ
' iIndex   ָCH341豸

Declare Function CH341SetParaMode Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByVal iMode As Long) As Boolean
' òģʽ
' iIndex   ָCH341豸
' iMode   ָģʽ: 0ΪEPPģʽ/EPPģʽV1.7, 1ΪEPPģʽV1.9, 2ΪMEMģʽ

Declare Function CH341InitParallel Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByVal iMode As Long) As Boolean

' λʼ,RST#͵ƽ
' iIndex   ָCH341豸
'  iMode   ָģʽ: 0ΪEPPģʽ/EPPģʽV1.7, 1ΪEPPģʽV1.9, 2ΪMEMģʽ, >= 0x00000100 ֵǰģʽ

Declare Function CH341ReadData0 Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByRef oBuffer As Any, ByRef ioLength As Long) As Boolean
' 0#˿ڶȡݿ
 ' iIndex     ָCH341豸
 ' oBuffer   ָһ㹻Ļ,ڱȡ
 ' ioLength   ָ򳤶ȵԪ,ʱΪ׼ȡĳ,غΪʵʶȡĳ

Declare Function CH341ReadData1 Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByRef oBuffer As Any, ByRef ioLength As Long) As Boolean
' 1#˿ڶȡݿ
' iIndex,  ָCH341豸
' oBuffer ָһ㹻Ļ,ڱȡ
' ioLength   ָ򳤶ȵԪ,ʱΪ׼ȡĳ,غΪʵʶȡĳ

Declare Function CH341AbortRead Lib "CH341DLL.DLL" (ByVal iIndex As Long) As Boolean
' ݿ
' iIndex    ָCH341豸

Declare Function CH341WriteData0 Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByRef iBuffer As Any, ByRef ioLength As Long) As Boolean
' 0#˿дݿ
' iIndex,    ָCH341豸
' iBuffer     ָһ,׼д
' ioLength  ָ򳤶ȵԪ,ʱΪ׼дĳ,غΪʵдĳ

Declare Function CH341WriteData1 Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByRef iBuffer As Any, ByRef ioLength As Long) As Boolean
' 1#˿дݿ
' iIndex,    ָCH341豸
' iBuffer,    ָһ,׼д
' ioLength   ָ򳤶ȵԪ,ʱΪ׼дĳ,غΪʵдĳ

Declare Function CH341AbortWrite Lib "CH341DLL.DLL" (ByVal iIndex As Long) As Boolean
' ݿд
' iIndex   ָCH341豸

Declare Function CH341GetStatus Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByRef iStatus As Long) As Boolean
'  ͨCH341ֱݺ״̬
'  iIndex,   ָCH341豸
'  iStatus  ָһ˫ֵԪ,ڱ״̬,
'  λ7-λ0ӦCH341D7-D0
'  λ8ӦCH341ERR#, λ9ӦCH341PEMP, λ10ӦCH341INT#, λ11ӦCH341SLCT, λ23ӦCH341SDA
'  λ13ӦCH341BUSY/WAIT#, λ14ӦCH341AUTOFD#/DATAS#,λ15ӦCH341SLCTIN#/ADDRS#

Declare Function CH341ReadI2C Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByVal iDevice As Byte, ByVal iAddr As Byte, ByRef oByte As Byte) As Boolean

'  I2Cӿڶȡһֽ
'  iIndex,   ָCH341豸
'  iDevice,    7λָI2C豸ַ
'  iAddr,    ָݵԪĵַ
'  oByte    ָһֽڵԪ,ڱȡֽ

Declare Function CH341WriteI2C Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByVal iDevice As Byte, ByVal iAddr As Byte, ByVal iByte As Byte) As Boolean

'    I2Cӿдһֽ
'    iIndex,   ָCH341豸
'    iDevice,   7λָI2C豸ַ
'    iAddr,  ָݵԪĵַ
'    iByte  дֽ

Declare Function CH341EppReadData Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByRef oBuffer As Any, ByRef ioLength As Long) As Boolean
'  EPPʽ: WR#=1, DS#=0, AS#=1, D0-D7=input
'  iIndex,    ָCH341豸
'  oBuffer,    ָһ㹻Ļ,ڱȡ
'  ioLength    ָ򳤶ȵԪ,ʱΪ׼ȡĳ,غΪʵʶȡĳ

Declare Function CH341EppReadAddr Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByRef oBuffer As Any, ByRef ioLength As Long) As Boolean
'  EPPʽַ: WR#=1, DS#=1, AS#=0, D0-D7=input
'  iIndex,    ָCH341豸
'  oBuffer,    ָһ㹻Ļ,ڱȡĵַ
'  ioLength   ָ򳤶ȵԪ,ʱΪ׼ȡĳ,غΪʵʶȡĳ

Declare Function CH341EppWriteData Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByRef iBuffer As Any, ByRef ioLength As Long) As Boolean
'   EPPʽд: WR#=0, DS#=0, AS#=1, D0-D7=output
'   iIndex,     ָCH341豸
'   iBuffer,    ָһ,׼д
'   ioLength     ָ򳤶ȵԪ,ʱΪ׼дĳ,غΪʵдĳ

Declare Function CH341EppWriteAddr Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByRef iBuffer As Any, ByRef ioLength As Long) As Boolean
'   EPPʽдַ: WR#=0, DS#=1, AS#=0, D0-D7=output
'   iIndex,    ָCH341豸
'   iBuffer,    ָһ,׼дĵַ
'   ioLength   ָ򳤶ȵԪ,ʱΪ׼дĳ,غΪʵдĳ

Declare Function CH341EppSetAddr Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByVal iAddr As Byte) As Boolean
' EPPʽõַ: WR#=0, DS#=1, AS#=0, D0-D7=output
' iIndex,  ָCH341豸
' iAddr   ָEPPַ

Declare Function CH341MemReadAddr0 Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByRef oBuffer As Any, ByRef ioLength As Long) As Boolean
' MEMʽַ0: WR#=1, DS#/RD#=0, AS#/ADDR=0, D0-D7=input
' iIndex,    ָCH341豸
' oBuffer,     ָһ㹻Ļ,ڱӵַ0ȡ
' ioLength   ָ򳤶ȵԪ,ʱΪ׼ȡĳ,غΪʵʶȡĳ

Declare Function CH341MemReadAddr1 Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByRef oBuffer As Any, ByRef ioLength As Long) As Boolean
' MEMʽַ1: WR#=1, DS#/RD#=0, AS#/ADDR=1, D0-D7=input
' iIndex,    ָCH341豸
' oBuffer,    ָһ㹻Ļ,ڱӵַ1ȡ
' ioLength    ָ򳤶ȵԪ,ʱΪ׼ȡĳ,غΪʵʶȡĳ

Declare Function CH341MemWriteAddr0 Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByRef iBuffer As Any, ByRef ioLength As Long) As Boolean
' MEMʽдַ0: WR#=0, DS#/RD#=1, AS#/ADDR=0, D0-D7=output
' iIndex,    ָCH341豸
' iBuffer,    ָһ,׼ַ0д
' ioLength    ָ򳤶ȵԪ,ʱΪ׼дĳ,غΪʵдĳ

Declare Function CH341MemWriteAddr1 Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByRef iBuffer As Any, ByRef ioLength As Long) As Boolean
'  MEMʽдַ1: WR#=0, DS#/RD#=1, AS#/ADDR=1, D0-D7=output
'  iIndex,   ָCH341豸
'  iBuffer,    ָһ,׼ַ1д
'  ioLength      ָ򳤶ȵԪ,ʱΪ׼дĳ,غΪʵдĳ

Declare Function CH341SetExclusive Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByVal iExclusive As Long) As Boolean
' öռʹõǰCH341豸
' iIndex,    ָCH341豸
' iExclusive  Ϊ0豸Թʹ,0ռʹ

Declare Function CH341SetTimeout Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByVal iWriteTimeout As Long, ByVal iReadTimeout As Long) As Boolean
'  USBݶдĳʱ
'  iIndex,  // ָCH341豸
'  iWriteTimeout  ָUSBдݿĳʱʱ,ԺmSΪλ,0xFFFFFFFFָʱ(Ĭֵ)
'  iReadTimeout  ָUSBȡݿĳʱʱ,ԺmSΪλ,0xFFFFFFFFָʱ(Ĭֵ)

Declare Function CH341ReadData Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByRef oBuffer As Any, ByRef ioLength As Long) As Boolean
' ȡݿ
' iIndex,    ָCH341豸
' oBuffer,    ָһ㹻Ļ,ڱȡ
' ioLength      ָ򳤶ȵԪ,ʱΪ׼ȡĳ,غΪʵʶȡĳ

Declare Function CH341WriteData Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByRef iBuffer As Any, ByRef ioLength As Long) As Boolean
'  дݿ
'  iIndex,    ָCH341豸
'  iBuffer,    ָһ,׼д
'  ioLength   ָ򳤶ȵԪ,ʱΪ׼дĳ,غΪʵдĳ

Declare Function CH341GetDeviceName Lib "CH341DLL.DLL" (ByVal iIndex As Long) As Long           ''''
' ָCH341豸ƵĻ,򷵻NULL
' iIndex   ָCH341豸,0Ӧһ豸

Declare Function CH341GetVerIC Lib "CH341DLL.DLL" (ByVal iIndex As Long) As Long
' ȡCH341оƬİ汾,:0=豸Ч,0x10=CH341,0x20=CH341A
' iIndex  ָCH341豸

Declare Function CH341FlushBuffer Lib "CH341DLL.DLL" (ByVal iIndex As Long) As Boolean
' CH341Ļ
' iIndex   ָCH341豸

Declare Function CH341WriteRead Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByVal iWriteLength As Long, ByRef iWriteBuffer As Any, ByVal iReadStep As Long, ByVal iReadTimes As Long, ByRef oReadLength As Long, ByRef oReadBuffer As Any) As Boolean
' CH341WriteRead   ִ,
' iIndex,    ָCH341豸
' iWriteLength,   д,׼дĳ
' iWriteBuffer,    ָһ,׼д
' iReadStep,    ׼ȡĵĳ, ׼ȡܳΪ(iReadStep*iReadTimes)
' iReadTimes,    ׼ȡĴ
' oReadLength,    ָ򳤶ȵԪ,غΪʵʶȡĳ
' oReadBuffer      ָһ㹻Ļ,ڱȡ

Declare Function CH341SetStream Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByVal iMode As Long) As Boolean

' CH341SetStream   ôģʽ
' iIndex,    ָCH341豸
' iMode      ָģʽ,
' λ1-λ0: I2Cӿٶ/SCLƵ, 00=/20KHz,01=׼/100KHz,10=/400KHz,11=/750KHz
' λ2:     SPII/O/IO, 0=뵥(D5/D7),1=˫˫(D5D4/D7D6)
' ,Ϊ0

Declare Function CH341SetDelaymS Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByVal iDelay As Long) As Boolean
'  CH341SetDelaymS     Ӳ첽ʱ,úܿ췵,һ֮ǰʱָ
 ' iIndex,    ָCH341豸
 ' iDelay      ָʱĺ

Declare Function CH341StreamI2C Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByVal iWriteLength As Long, ByRef iWriteBuffer As Any, ByVal iReadLength As Long, ByRef oReadBuffer As Any) As Boolean
' CH341StreamI2C     I2C,2߽ӿ,ʱΪSCL,ΪSDA(׼˫I/O),ٶԼ56Kֽ
' iIndex,    ָCH341豸
' iWriteLength,    ׼дֽ
' iWriteBuffer,    ָһ,׼д,ֽͨI2C豸ַдλ
' iReadLength,     ׼ȡֽ
' oReadBuffer     ָһ,غǶ
Declare Function CH341ReadEEPROM Lib "CH341DLL.DLL" (ByVal iIndexas As Long, ByVal iEepromID As EEPROM_TYPE, ByVal iAddr As Long, ByVal iLength As Long, ByRef oBuffer As Any) As Boolean
' CH341ReadEEPROM EEPROMжȡݿ,ٶԼ56Kֽ
' i    Index  ָCH341豸
' iEepromID   ָEEPROMͺ
' iAddr       ָݵԪĵַ
' iLength     ׼ȡֽ
' oBuffer     ָһ,غǶ

Declare Function CH341WriteEEPROM Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByVal iEepromID As EEPROM_TYPE, ByVal iAddr As Long, ByVal iLength As Long, ByRef iBuffer As Any) As Boolean
' CH341WriteEEPROM EEPROMдݿ
' iIndex,    ָCH341豸
' iEepromID, ָEEPROMͺ
' iAddr,     ָݵԪĵַ
' iLength,   ׼дֽ
' iBuffer    ָһ,׼д

Declare Function CH341GetInput Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByRef iStatus As Long) As Boolean
' CH341GetInput ͨCH341ֱݺ״̬,ЧʱCH341GetStatus
' iIndex,  ָCH341豸
' iStatus  ָһ˫ֵԪ,ڱ״̬,ολ˵
' λ7-λ0ӦCH341D7-D0
' λ8ӦCH341ERR#, λ9ӦCH341PEMP, λ10ӦCH341INT#, λ11ӦCH341SLCT, λ23ӦCH341SDA
' λ13ӦCH341BUSY/WAIT#, λ14ӦCH341AUTOFD#/DATAS#,λ15ӦCH341SLCTIN#/ADDRS#

Declare Function CH341SetOutput Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByVal iEnable As Long, ByVal iSetDirOut As Long, ByVal iSetDataOut As Long) As Boolean
' CH341SetOutput CH341I/O,ͨCH341ֱ
' ***** ʹøAPI, ֹ޸I/OʹűΪŵ֮·оƬ *****
' iIndex,  ָCH341豸
' iEnable, Ч־,ολ˵
'// λ0Ϊ1˵iSetDataOutλ15-λ8Ч,
'// λ1Ϊ1˵iSetDirOutλ15-λ8Ч,
'// λ2Ϊ1˵iSetDataOut7-λ0Ч,
'// λ3Ϊ1˵iSetDirOutλ7-λ0Ч,
'// λ4Ϊ1˵iSetDataOutλ23-λ16Ч,
' iSetDirOut, I/O,ĳλ0ӦΪ,ĳλ1ӦΪ,ڷʽĬֵΪ0x000FC000,ολ˵
' iSetDataOut ,I/OΪ,ôĳλ0ʱӦ͵ƽ,ĳλ1ʱӦߵƽ,ολ˵
'// λ7-λ0ӦCH341D7-D0
'// λ8ӦCH341ERR#, λ9ӦCH341PEMP, λ10ӦCH341INT#, λ11ӦCH341SLCT
'// λ13ӦCH341WAIT#, λ14ӦCH341DATAS#/READ#,λ15ӦCH341ADDRS#/ADDR/ALE
'// ֻ,I/O: λ16ӦCH341RESET#, λ17ӦCH341WRITE#, λ18ӦCH341SCL, λ29ӦCH341SDA

Declare Function CH341Set_D5_D0 Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByVal iSetDirOut As Long, ByVal iSetDataOut As Long) As Boolean
' CH341Set_D5_D0 CH341D5-D0ŵI/O,ͨCH341D5-D0ֱ,ЧʱCH341SetOutput
' ***** ʹøAPI, ֹ޸I/OʹűΪŵ֮·оƬ *****
' iIndex,      ָCH341豸
' iSetDirOut,  D5-D0ŵI/O,ĳλ0ӦΪ,ĳλ1ӦΪ,ڷʽĬֵΪ0x00ȫ
' iSetDataOut  D5-D0ŵ,I/OΪ,ôĳλ0ʱӦ͵ƽ,ĳλ1ʱӦߵƽ
'// ݵλ5-λ0ֱӦCH341D5-D0

Declare Function CH341StreamSPI3 Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByVal iChipSelect As Long, ByVal iLength As Long, ByRef ioBuffer As Any) As Boolean
' CH341StreamSPI3 SPI,3߽ӿ,ʱΪDCK2/SCL,ΪDIO/SDA(׼˫I/O),ƬѡΪD0/D1/D2,ٶԼ51Kֽ
' SPIʱ: DCK2/SCLΪʱ, ĬΪ͵ƽ, DIO/SDAʱ֮ǰ, DIO/SDAʱ½֮
' iIndex,   ָCH341豸
' iChipSelect,Ƭѡ, λ7Ϊ0Ƭѡ, λ7Ϊ1Ч: λ1λ0Ϊ00/01/10ֱѡD0/D1/D2Ϊ͵ƽЧƬѡ
' iLength,    ׼ֽ
' ioBuffer    ָһ,׼DIOд,غǴDIO

Declare Function CH341StreamSPI4 Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByVal iChipSelect As Long, ByVal iLength As Long, ByRef ioBuffer As Any) As Boolean
' CH341StreamSPI4 SPI,4߽ӿ,ʱΪDCK/D3,ΪDOUT/D5,ΪDIN/D7,ƬѡΪD0/D1/D2,ٶԼ68Kֽ
' SPIʱ: DCK/D3Ϊʱ, ĬΪ͵ƽ, DOUT/D5ʱ֮ǰ, DIN/D7ʱ½֮
' iIndex,   ָCH341豸
' iChipSelect,Ƭѡ, λ7Ϊ0Ƭѡ, λ7Ϊ1Ч: λ1λ0Ϊ00/01/10ֱѡD0/D1/D2Ϊ͵ƽЧƬѡ
' iLength,    ׼ֽ
' ioBuffer    ָһ,׼DOUTд,غǴDIN

Declare Function CH341StreamSPI5 Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByVal iChipSelect As Long, ByVal iLength As Long, ByRef ioBuffer As Any, ByRef ioBuffer2 As Any) As Boolean
' CH341StreamSPI5 SPI,5߽ӿ,ʱΪDCK/D3,ΪDOUT/D5DOUT2/D4,ΪDIN/D7DIN2/D6,ƬѡΪD0/D1/D2,ٶԼ30Kֽ*2
' SPIʱ: DCK/D3Ϊʱ, ĬΪ͵ƽ, DOUT/D5DOUT2/D4ʱ֮ǰ, DIN/D7DIN2/D6ʱ½֮
' iIndex,   ָCH341豸
' iChipSelect,Ƭѡ, λ7Ϊ0Ƭѡ, λ7Ϊ1Ч: λ1λ0Ϊ00/01/10ֱѡD0/D1/D2Ϊ͵ƽЧƬѡ
' iLength,    ׼ֽ
' ioBuffer,   ָһ,׼DOUTд,غǴDIN
' ioBuffer2   ָڶ,׼DOUT2д,غǴDIN2

Declare Function CH341BitStreamSPI Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByVal iLength As Long, ByRef ioBuffer As Any) As Boolean
' CH341BitStreamSPI SPIλ,4/5߽ӿ,ʱΪDCK/D3,ΪDOUT/DOUT2,ΪDIN/DIN2,ƬѡΪD0/D1/D2,ٶԼ8Kλ*2
' iIndex,  ָCH341豸
' iLength, ׼λ,һ896,鲻256
' ioBuffer ָһ,׼DOUT/DOUT2/D2-D0д,غǴDIN/DIN2
'/* SPIʱ: DCK/D3Ϊʱ, ĬΪ͵ƽ, DOUT/D5DOUT2/D4ʱ֮ǰ, DIN/D7DIN2/D6ʱ½֮ */
'/* ioBufferеһֽڹ8λֱӦD7-D0, λ5DOUT, λ4DOUT2, λ2-λ0D2-D0, λ7DIN, λ6DIN2, λ3ݺ */
'/* ڵøAPI֮ǰ,ӦȵCH341Set_D5_D0CH341D5-D0ŵI/O,ŵĬϵƽ */

Declare Function CH341SetBufUpload Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByVal iEnableOrClear As Long) As Boolean  ' Ϊ0ֹڲϴģʽ,ʹֱϴ,0ڲϴģʽе
' CH341SetBufUpload  ' 趨ڲϴģʽ
' iIndex,          0ָCH341豸,0Ӧһ豸
' iEnableOrClear  Ϊ0ֹڲϴģʽ,ʹֱϴ,0ڲϴģʽе
' ڲϴģʽ,ôCH341򴴽߳ԶUSBϴݵڲ,ͬʱе,ӦóCH341ReadDataػе

Declare Function CH341QueryBufUpload Lib "CH341DLL.DLL" (ByVal iIndex As Long) As Long
' CH341QueryBufUpload   ѯڲϴеݰ,ɹݰ,-1
' iIndex                ָCH341豸,0Ӧһ豸

Declare Function CH341SetBufDownload Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByVal iEnableOrClear As Long) As Boolean
'  CH341SetBufDownload  趨ڲ´ģʽ
'  iIndex,              ָCH341豸,0Ӧһ豸
'  iEnableOrClear       Ϊ0ֹڲ´ģʽ,ʹֱ´,0ڲ´ģʽе
'  ڲ´ģʽ,ôӦóCH341WriteData󽫽ǽUSB´ݷŵڲ,CH341򴴽߳Զֱ

Declare Function CH341QueryBufDownload Lib "CH341DLL.DLL" (ByVal iIndex As Long) As Long    ' ָCH341豸,0Ӧһ豸
'  CH341QueryBufDownload  ѯڲ´еʣݰ(δ),ɹݰ,-1
'  iIndex                 ָCH341豸,0Ӧһ豸


Declare Function CH341ResetInter Lib "CH341DLL.DLL" (ByVal iIndex As Long) As Boolean
'  CH341ResetInter   λжݶ
'  iIndex            ָCH341豸

Declare Function CH341ResetRead Lib "CH341DLL.DLL" (ByVal iIndex As Long) As Boolean
'  CH341ResetRead  λݿ
'  iIndex          ָCH341豸

Declare Function CH341ResetWrite Lib "CH341DLL.DLL" (ByVal iIndex As Long) As Boolean
'    CH341ResetRead    λݿ
'    iIndex            ָCH341豸

'typedef     VOID    ( CALLBACK  * mPCH341_NOTIFY_ROUTINE ) (  ' 豸¼֪ͨص
'    ULONG           iEventStatus );  ' 豸¼͵ǰ״̬(ж): 0=豸γ¼, 3=豸¼

Public Const CH341_DEVICE_ARRIVAL = 3               ' 豸¼,Ѿ
Public Const CH341_DEVICE_REMOVE_PEND = 1         ' 豸Ҫγ
Public Const CH341_DEVICE_REMOVE = 0              ' 豸γ¼,Ѿγ

Declare Function CH341SetDeviceNotify Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByRef iDeviceID As String, ByVal iNotifyRoutine As Long) As Boolean
'  CH341SetDeviceNotify     趨豸¼֪ͨ
'  iIndex,                  ָCH341豸,0Ӧһ豸
'  iDeviceID,               ѡ,ַָ,ָص豸ID,ַ\0ֹ
'  iNotifyRoutine           (ַ)ָ豸¼ص, ΪNULLȡ¼֪ͨ, ڼ⵽¼ʱøó


Declare Function CH341SetupSerial Lib "CH341DLL.DLL" (ByVal iIndex As Long, ByVal iParityMode As Long, ByVal iBaudRate As Long) As Boolean
'  CH341SetupSerial    趨CH341Ĵ,APIֻڹڴڷʽCH341оƬ
'  iIndex,             ָCH341豸,0Ӧһ豸
'  iParityMode,        ָCH341ڵУģʽ: NOPARITY/ODDPARITY/EVENPARITY/MARKPARITY/SPACEPARITY
'  iBaudRate           ָCH341ڵͨѶֵ,503000000ֵ֮

'/*  APIڹڴڷʽCH341оƬ,֮APIһֻڲڷʽCH341оƬ
'    CH341OpenDevice
'    CH341CloseDevice
'    CH341SetupSerial
'    CH341ReadData
'    CH341WriteData
'    CH341SetBufUpload
'    CH341QueryBufUpload
'    CH341SetBufDownload
'    CH341QueryBufDownload
'    CH341SetDeviceNotify
'    CH341GetStatus
'  ҪAPI,ǴҪAPI
'    CH341GetVersion
'    CH341DriverCommand
'    CH341GetDrvVersion
'    CH341ResetDevice
'    CH341GetDeviceDescr
'    CH341GetConfigDescr
'    CH341SetIntRoutine
'    CH341ReadInter
'    CH341AbortInter
'    CH341AbortRead
'    CH341AbortWrite
'    CH341ReadI2C
'    CH341WriteI2C
'    CH341SetExclusive
'    CH341SetTimeout
'    CH341GetDeviceName
'    CH341GetVerIC
'    CH341FlushBuffer
'    CH341WriteRead
'    CH341ResetInter
'    CH341ResetRead
'    CH341ResetWrite
'*/
