/* 2004.03.05
****************************************
**  Copyright  (C)  W.ch  1999-2004   **
**  Web:  http://www.winchiphead.com  **
****************************************
**  USB 1.1 Host Examples for CH375   **
**  KC7.0@MCS-51                      **
****************************************
*/
/* CH375ΪUSBӿڵĳʾ,жϷʽ */

/* MCS-51ƬCԵʾ, Uݶд */

#include <reg51.h>
#include <string.h>
#include <stdio.h>

#ifndef	TRUE
#define	TRUE	1
#define	FALSE	0
#endif

/* CH375뼰״̬ */
#include "CH375INC.H"

/* ¶MCS-51Ƭ,Ƭ޸,ΪṩCԵٶҪԱŻ */
#include <reg51.h>
unsigned char volatile xdata	CH375_CMD_PORT _at_ 0xBDF1;	/* CH375˿ڵI/Oַ */
unsigned char volatile xdata	CH375_DAT_PORT _at_ 0xBCF0;	/* CH375ݶ˿ڵI/Oַ */
unsigned char xdata				DATA_BUFFER[8192] _at_ 0x0000;	/* ⲿRAMݻʼַ,Ȳһζдݳ */

/* P1.4һLEDڼʾĽ,͵ƽLED,U̲ */
sbit P1_4  = P1^4;
#define LED_OUT_ACT( )		{ P1_4 = 0; }	/* P1.4 ͵ƽLEDʾ */
#define LED_OUT_INACT( )	{ P1_4 = 1; }	/* P1.4 ͵ƽLEDʾ */

unsigned char volatile			UdiskStatus;	/* ǰU״̬, */
#define		STATUS_DISCONNECT		0	/* UδӻѾϿ */
#define		STATUS_CONNECT			1	/* U̸ո */
#define		STATUS_ERROR			2	/* U̲߲֧ */
#define		STATUS_WAIT				3	/* Uڲ */
#define		STATUS_READY			4	/* U׼ýܲ */

/*
  USBƶ洢豸ļӦòοڵƬӦóУ
  ԶUSB洢豸4״̬ѶϿӡʼɶд""״̬ѡ
 ѶϿָUSB洢豸ѾϿUSBаγȫã
 ָUSB洢豸ѾӣUSBУδʼ
 ʼָUSB洢豸ڳʼ߳ʼʧܣԲԽжд
 ɶдָUSB洢豸ʼɹԽݶд

ƬCH375жϵһ㲽£
 CH375INT#Ϊ͵ƽƬжϣ
 ƬжϷִGET_STATUSȡж״̬
 CH375GET_STATUSɺINT#ŻָΪߵƽȡж
 ƬԲο˳GET_STATUSȡж״̬
   ж״̬USB_INT_DISCONNECT˵USB豸ѾϿUSB洢豸״̬Ϊ"ѶϿ"
     ڴ֮ǰUSB洢豸ждδɣʧܴȻ˳жϣҪʱ֪ͨƬ
   ж״̬USB_INT_CONNECT˵USB豸ѾӣUSB洢豸״̬Ϊ""
     ŷDISK_INITUSB洢豸״̬ΪʼȻ˳жϣҪʱ֪ͨƬ
   ǰUSB洢豸״̬"ʼ"
     ж״̬USB_INT_SUCCESS˵USB洢豸ʼɹUSB洢豸״̬Ϊ"ɶд"
       Ȼ˳жϣҪʱ֪ͨƬ
     ж״̬״̬˵USB洢豸ʼʧܣӦ֪ͨƬ
       ʾUSB豸Ǵ洢豸߸USB豸֧֣Ȼ˳жϡߣƬͨдUSB洢豸ͨѶЭ顣
   ǰUSB洢豸״̬"ɶд"Աж״̬֪ͨƬ
     Ȼֱ˳жϣߣжϷм
     ж״̬USB_INT_DISK_READ˵ڽUSB洢豸ĶҪȡ64ֽڵݣ
       ԷRD_USB_DATAȡݣٷDISK_RD_GOʹCH375Ȼ˳жϡ
     ж״̬USB_INT_DISK_WRITE˵ڽUSB洢豸дҪṩ64ֽڵݣ
       ԷWR_USB_DATA7ṩݣٷDISK_WR_GOʹCH375дȻ˳жϡ
     ж״̬USB_INT_SUCCESS˵дɹֱ˳жϲ֪ͨòɹ
     ж״̬USB_INT_DISK_ERR˵дʧܣֱ˳жϲ֪ͨòʧܣ
     ͨ᷵ж״̬У˵ִ
   ͨUSB洢豸״̬·ж״̬У˵ִ󣬿ԲUSB豸Ͽ״̬

ƬҪUSB洢豸ждʱԲѯUSB洢豸״̬
"ɶд"״̬ԷDISK_READݣ߷DISK_WRITEдݡ
ݶд̿ڵƬжϷɣҲжϳñ־֪ͨȴе
ж״̬ݶд̡
*/

unsigned char *mBufferPoint;

/* ʱ2΢,ȷ */
void	delay2us( )
{
	unsigned char i;
	for ( i = 2; i != 0; i -- );
}

/* ʱ1΢,ȷ */
void	delay1us( )
{
	unsigned char i;
	for ( i = 1; i != 0; i -- );
}

/* ʱ100,ȷ */
void	mDelay100mS( )
{
	unsigned char	i, j, c;
	for ( i = 200; i != 0; i -- ) for ( j = 200; j != 0; j -- ) c+=3;
}

/*  */

void CH375_WR_CMD_PORT( unsigned char cmd ) {  /* CH375˿д,ڲС4uS,ƬϿʱ */
	delay2us();
	CH375_CMD_PORT=cmd;
	delay2us();
}

void CH375_WR_DAT_PORT( unsigned char dat ) {  /* CH375ݶ˿д,ڲС1.5uS,ƬϿʱ */
	CH375_DAT_PORT=dat;
	delay1us();  /* ΪMCS51Ƭʵʱ */
}

unsigned char CH375_RD_DAT_PORT() {  /* CH375ݶ˿ڶ,ڲС1.5uS,ƬϿʱ */
	delay1us();  /* ΪMCS51Ƭʵʱ */
	return( CH375_DAT_PORT );
}

/* CH375INT#51ƬINT0, жϷʽ */
/* CH375жϷ,ʹüĴ1 */
void	CH375Interrupt( ) interrupt 0 using 1
{
	unsigned char i, s, len;
	CH375_WR_CMD_PORT( CMD_GET_STATUS );  /* ȡж״̬ȡж */
	for ( i = 2; i != 0; i -- );  /* ʱ2uS */
	s = CH375_RD_DAT_PORT( );  /* ȡж״̬ */
	if ( s == USB_INT_SUCCESS ) UdiskStatus = STATUS_READY;  /* ɹ */
	else if ( s == USB_INT_DISCONNECT ) {
		UdiskStatus = STATUS_DISCONNECT;  /* ⵽USB豸Ͽ¼ */
		LED_OUT_INACT( );
	}
	else if ( s == USB_INT_CONNECT ) {
		UdiskStatus = STATUS_CONNECT;  /* ⵽USB豸¼ */
		LED_OUT_ACT( );
	}
	else if ( s == USB_INT_DISK_READ ) {  /* USB洢ݿ,ݶ */
		CH375_WR_CMD_PORT( CMD_RD_USB_DATA );  /* CH375ȡݿ */
		for ( i = 2; i != 0; i -- );  /* ʱ2uS */
		len = CH375_RD_DAT_PORT( );  /* ݵĳ */
		while ( len ) {  /* ݳȶȡ */
			*mBufferPoint = CH375_RD_DAT_PORT( );  /* ݲ */
			mBufferPoint ++;
			len --;
		}
		CH375_WR_CMD_PORT( CMD_DISK_RD_GO );  /* ִUSB洢Ķ */
	}
	else if ( s == USB_INT_DISK_WRITE ) {  /* USB洢дݿ,д */
		CH375_WR_CMD_PORT( CMD_WR_USB_DATA7 );  /* CH375дݿ */
		for ( i = 2; i != 0; i -- );  /* ʱ2uS */
		len = CH375_MAX_DATA_LEN;
		CH375_WR_DAT_PORT( len );  /* ݵĳ */
		do {  /* C51,DO+WHILEṹWHILEЧʸ,ٶȿ */
			CH375_WR_DAT_PORT( *mBufferPoint );
			mBufferPoint ++;
		} while ( -- len );
		CH375_WR_CMD_PORT( CMD_DISK_WR_GO );  /* ִUSB洢д */
	}
	else {  /* ʧ */
		UdiskStatus = STATUS_ERROR;
	}
/*	CH375_INT_FLAG = 0;  жϱ־ */
}

/* CH375ΪUSBʽ */
unsigned char	mCH375Init( )
{
	unsigned char	i;
	UdiskStatus = STATUS_DISCONNECT;
	CH375_WR_CMD_PORT( CMD_SET_USB_MODE );  /* USBģʽ */
	CH375_WR_DAT_PORT( 6 );  /* ģʽ,ԶUSB豸 */
	for ( i = 0xff; i != 0; i -- ) {  /* ȴɹ,ͨҪȴ10uS-20uS */
		if ( CH375_RD_DAT_PORT( ) == CMD_RET_SUCCESS ) break;  /* ɹ */
	}
	if ( i != 0 ) return( TRUE );  /* ɹ */
	else return( FALSE );  /* CH375,оƬͺŴߴڴڷʽ߲֧ */
}

/* ȴU׼ûߵȴϴβ */
unsigned char	mWaitReady( )
{
	while( UdiskStatus == STATUS_WAIT );  /* ȴϴβ */
	if ( UdiskStatus == STATUS_READY ) return( TRUE );  /* UѾ׼ò,ϴβɹ */
	else if ( UdiskStatus == STATUS_ERROR ) {  /* ϴβʧ */
		UdiskStatus = STATUS_WAIT;
		CH375_WR_CMD_PORT( CMD_DISK_RESET );  /* λU */
		while( UdiskStatus == STATUS_WAIT );  /* ȴж״̬ */
		if ( UdiskStatus == STATUS_READY ) return( TRUE );  /* ȴж״̬,ɹ */
		return( FALSE );  /* UdiskStatus = STATUS_ERROR */
	}
	else if ( UdiskStatus == STATUS_DISCONNECT ) {  /* UѾϿ */
/*		while ( UdiskStatus == STATUS_DISCONNECT );*/
		return( FALSE );
	}
	else if ( UdiskStatus == STATUS_CONNECT ) {  /* UѾ */
		mDelay100mS( );  /* U̸ղôԵһٲ */
		mDelay100mS( );
		CH375_WR_CMD_PORT( CMD_DISK_INIT );  /* ʼUSB洢 */
		while ( UdiskStatus == STATUS_CONNECT );  /* ȴж״̬ */
		if ( UdiskStatus == STATUS_READY ) {  /* ɹ,Ѿʼװϵͳ */
/* UǷ׼,U̲Ҫһ,ĳЩU̱Ҫִһܹ */
//	do {
//		mDelay100mS( );
//		printf( "Disk Ready ?\n" );
//		i = CH375DiskReady( );  /* ѯǷ׼,ʡӳԽԼ1KBĳ */
//	} while ( i != ERR_SUCCESS );
/* CH375DiskReady CH375Uļӳ,Ϊ϶,Դ˴ʡȥ */
			return( TRUE );
		}
		else return( FALSE );
	}
	return( FALSE );
}

/* U̶ȡݿ鵽 */
unsigned char	mReadSector( unsigned long iLbaStart, unsigned char iSectorCount, unsigned char *iBuffer )
/* iLbaStart ׼ȡʼ, iSectorCount ׼ȡ, iBuffer ǴŷݵĻַ */
{
	if ( mWaitReady( ) == FALSE ) return( FALSE );
	mBufferPoint = iBuffer;  /* ָ򻺳ʼַ */
	UdiskStatus = STATUS_WAIT;
	CH375_WR_CMD_PORT( CMD_DISK_READ );  /* USB洢ݿ */
	CH375_WR_DAT_PORT( (unsigned char)iLbaStart );  /* LBA8λ */
	CH375_WR_DAT_PORT( (unsigned char)( iLbaStart >> 8 ) );
	CH375_WR_DAT_PORT( (unsigned char)( iLbaStart >> 16 ) );
	CH375_WR_DAT_PORT( (unsigned char)( iLbaStart >> 24 ) );  /* LBA8λ */
	CH375_WR_DAT_PORT( iSectorCount );  /*  */
/* ǴжϷʽ,ô,жϷȡ */
	return( mWaitReady( ) );
}

/* еĶݿдU */
unsigned char	mWriteSector( unsigned long iLbaStart, unsigned char iSectorCount, unsigned char *iBuffer )
/* iLbaStart дʼ, iSectorCount д, iBuffer Ǵ׼дݵĻַ */
{
	if ( mWaitReady( ) == FALSE ) return( FALSE );
	mBufferPoint = iBuffer;  /* ָ򻺳ʼַ */
	UdiskStatus = STATUS_WAIT;
	CH375_WR_CMD_PORT( CMD_DISK_WRITE );  /* USB洢дݿ */
	CH375_WR_DAT_PORT( (unsigned char)iLbaStart );  /* LBA8λ */
	CH375_WR_DAT_PORT( (unsigned char)( iLbaStart >> 8 ) );
	CH375_WR_DAT_PORT( (unsigned char)( iLbaStart >> 16 ) );
	CH375_WR_DAT_PORT( (unsigned char)( iLbaStart >> 24 ) );  /* LBA8λ */
	CH375_WR_DAT_PORT( iSectorCount );  /*  */
/* ǴжϷʽ,ô,жϷȡ */
	return( mWaitReady( ) );
}

struct _HD_MBR_DPT {
	unsigned char	PartState;
	unsigned char	StartHead;
	unsigned int	StartSec;
	unsigned char	PartType;
	unsigned char	EndHead;
	unsigned int	EndSec;
	unsigned long	StartSector;
	unsigned long	TotalSector;
};

/* Ϊprintfgetkeyʼ */
void	mInitSTDIO( )
{
	SCON = 0x50;
	PCON = 0x80;
	TMOD = 0x20;
	TH1 = 0xf3;  /* 24MHz, 9600bps */
	TR1 = 1;
	TI = 1;
}

main( ) {
	unsigned char	c;
	LED_OUT_ACT( );  /* LEDһʾ */
	mDelay100mS( );  /* ʱ100 */
	LED_OUT_INACT( );
	mInitSTDIO( );
	printf( "Start\n" );
	c = mCH375Init( );  /* ʼCH375 */
	if ( c == FALSE ) printf( "Error @CH375Init\n" );
	printf( "Insert USB disk\n" );
	while ( 1 ) {  /*  */
		mDelay100mS( );
		mDelay100mS( );
		mDelay100mS( );
		mDelay100mS( );
		mDelay100mS( );
/*  */
/* U̶ȡ */
		printf( "Read\n" );
		c = mReadSector( 0, 5, DATA_BUFFER );
		if ( c == FALSE ) printf( "Error @ReadSector\n" );
/* Uд */
		c = mWriteSector( 1, 1, DATA_BUFFER );
		if ( c == FALSE ) printf( "Error @WriteSector\n" );
/*  */
		mDelay100mS( );
		mDelay100mS( );
		mDelay100mS( );
		mDelay100mS( );
		mDelay100mS( );
	}
}
