// Can_BusDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Can_Bus.h"
#include "Can_BusDlg.h"
#include "CanDll.h"
#include "WINBASE.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define			MAX_REGION		8
#define			MAX_SUBID		32

ULONG			m_IntLine	;
PCHAR			Func[4]={"Open Node","Close Node","Red Node","Green Node"};
UCHAR			ACR_Code[4]={	0,	0,	0,	0};
UCHAR			AMR_Code[4]={	0xff,	0xff,	0xff,	0xff};
UCHAR			Func_Code[4]={0x01,	0x02,	0x03,	0x04};//ӦĹܺţɸģ

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCan_BusDlg dialog

CCan_BusDlg::CCan_BusDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCan_BusDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCan_BusDlg)
	m_Mode = _T("");
	m_Status = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CCan_BusDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCan_BusDlg)
	DDX_Control(pDX, IDC_BUTTON_OPEN, m_OpenCtrl);
	DDX_Control(pDX, IDC_BUTTON_SEND, m_SendCtrl);
	DDX_Control(pDX, IDC_CHECK_TEST, m_TestCtrl);
	DDX_Control(pDX, IDC_RADIO_DATA, m_Radio_Data);
	DDX_Control(pDX, IDC_LIST_VIEW, m_ListCtrl);
	DDX_Control(pDX, IDC_EDIT_DATA, m_DataCtrl);
	DDX_Control(pDX, IDC_COMBO_NAME, m_NameCtrl);
	DDX_Control(pDX, IDC_COMBO_FUNC, m_FuncCtrl);
	DDX_Text(pDX, IDC_EDIT_MODE, m_Mode);
	DDX_Text(pDX, IDC_EDIT_STATUS, m_Status);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCan_BusDlg, CDialog)
	//{{AFX_MSG_MAP(CCan_BusDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_RADIO_DATA, OnRadioData)
	ON_BN_CLICKED(IDC_RADIO_REMOT, OnRadioRemot)
	ON_BN_CLICKED(IDC_CHECK_TEST, OnCheckTest)
	ON_BN_CLICKED(IDC_BUTTON_OPEN, OnButtonOpen)
	ON_BN_CLICKED(IDC_BUTTON_SEND, OnButtonSend)
	ON_BN_CLICKED(ID_CANCEL, OnCancel)
	ON_BN_CLICKED(IDC_BUTTON_CLEAR, OnButtonClear)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCan_BusDlg message handlers

BOOL CCan_BusDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	// ACR&AMR Format:*******,********,********,******88.
	K_Return=TRUE;
	m_ThreadOp=TRUE;		//߳ʹܣ
	m_DeviceStatus=FALSE;

	m_TestCtrl.SetCheck(1);
	m_Mode=_T("On");
	UpdateData(FALSE);
	m_DebugMode=1;
		
	for(int i=0;i<4;i++)
		m_FuncCtrl.AddString(Func[i]);
	m_FuncCtrl.SetCurSel(0);
	m_Radio_Data.SetCheck(1);
	m_FrameMode=0;
	m_NameCtrl.ResetContent();

	m_SendCtrl.EnableWindow(FALSE);
	m_FuncCtrl.EnableWindow(FALSE);
	m_NameCtrl.EnableWindow(FALSE);
	m_DataCtrl.EnableWindow(FALSE);
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CCan_BusDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CCan_BusDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CCan_BusDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CCan_BusDlg::OnRadioData() 
{
	// TODO: Add your control notification handler code here
	m_FrameMode=0;
}

void CCan_BusDlg::OnRadioRemot() 
{
	// TODO: Add your control notification handler code here
	m_FrameMode=1;
}

BOOL CCan_BusDlg::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: Add your specialized code here and/or call the base class
	if (pMsg->wParam ==VK_RETURN)
	{
		if(!m_DeviceStatus)
		{
			MessageBox("CAN豸δ","Ϣ",MB_OK);
			return true;
		}
		if(K_Return)
		{
			OnButtonSend();
		}
		K_Return=(!K_Return);
		return true;			
	}
	if (pMsg->wParam == VK_ESCAPE)
	{
		return true;
	}
	return CDialog::PreTranslateMessage(pMsg);
}

void CCan_BusDlg::OnCheckTest() 
{
	// TODO: Add your control notification handler code here
	
	if(	m_TestCtrl.GetCheck())
	{
	
		m_Mode=_T("On");
		UpdateData(FALSE);
		m_DebugMode=1;	
	}
	else
	{
		m_Mode=_T("Off");
		UpdateData(FALSE);
		m_DebugMode=0;
	}
	
}
void CCan_BusDlg::OnButtonOpen() 
{
//	mPCH365_INT_ROUTINE  Interrupt=CH365_CanBus_Interrupt;
	if(CH365_Can_mOpenDevice() == INVALID_HANDLE_VALUE)
	{
		MessageBox("The Device Open  ERROR!");
		return ;
	}	
	if(!CH365_Can_mSetIntLine(mCH365_INT_LINE_AUTO))
	{
		MessageBox("Setting INT ERROR!");
	}
	if(!CH365_Can_mGetIntLine(&m_IntLine ))
	{
		MessageBox("Get INTLine ERROR!");
	}
	else
	{
		char str[5];
		sprintf(str,"%d",m_IntLine);
		MessageBox(str);
		MessageBox("The MainChip 365  Init OK");
	}
	
	if(!CH365_CanBus_Init(	AMR_Code	,//AMR	
							ACR_Code	,//ACR	ʶ
							0x40		,//
							0x18		,//趨
							m_DebugMode	))//ģʽ
	{
		MessageBox(" The Can's Chip Init ERROR!");
		return;
	}

	CWinThread * My_ThreadObj=NULL;
	My_ThreadObj=AfxBeginThread (CH365Rece_thread,this,THREAD_PRIORITY_NORMAL,0,0,NULL);
	if(My_ThreadObj)
	{
		MessageBox("Start Thread is Ok!");
	}
	else
	{
		MessageBox("Start Thread ERROR!");
		return ;
	}

	switch(m_DebugMode){
	case 0:
		//notice do not use this unless u have the right
//		m_FuncCtrl.EnableWindow(TRUE);
//		m_NameCtrl.EnableWindow(TRUE);
	case 1:
		m_SendCtrl.EnableWindow(TRUE);
		m_DataCtrl.EnableWindow(TRUE);
		m_DeviceStatus=TRUE;
		break;
	default:
		MessageBox("Mode Error!");
		return;
		break;
	}
		
	m_Status=_T("OK");
	UpdateData(FALSE);
	

}


void CCan_BusDlg::OnCancel() 
{
	// TODO: Add your control notification handler code here
	
	m_ThreadOp=FALSE;
	Sleep(10);
	CH365mCloseDevice();
	Sleep(0L);
	m_Status=_T("Close");
	UpdateData(FALSE);
	OnOK();
}

UINT CH365Rece_thread(PVOID pDlg)
{	
	CCan_BusDlg	 *	p_Dlg=(CCan_BusDlg * ) pDlg;
	p_Frame			m_Sys_Frame=new m_Frame;
	CString			m_Swap;
	while(p_Dlg->m_ThreadOp)	
	{		
		if(CH365_CanRece(m_Sys_Frame))
		{
			m_Swap=(CHAR *)(m_Sys_Frame->DATA);
			m_Swap=m_Swap.Left((m_Sys_Frame->StartFrame)&0x0f);
			p_Dlg->m_ListCtrl.InsertString(-1,m_Swap);
			Sleep(0);
		}
		Sleep(20);
	}
	ExitThread(0);
	delete(m_Sys_Frame);
	return 0;
}

void  CCan_BusDlg::OnButtonSend() 
{
	if(m_DeviceStatus)
	{
		if(m_DebugMode)
		{
			iFunc=0xff;
			iExFunc=0xcc;
			iRegion=0xaa;
			iSubId=0x01;
		}
		else
		{
			if(m_FuncCtrl.GetCurSel()!=CB_ERR)//have been Selected
			{
				iFunc=Func_Code[m_FuncCtrl.GetCurSel()];
				iExFunc=0x00;		//չ
			}
			if(m_NameCtrl.GetCurSel()!=CB_ERR)
			{
				iRegion=(m_NameCtrl.GetCurSel())/MAX_REGION;
				iSubId=(m_NameCtrl.GetCurSel())/MAX_REGION;
			}
		}
		iMode=m_FrameMode;			//ȷ֡
		CString s_Data,Data="";
		char	str[1000];
		char	m_data[8];
		int		m_count=0;
		m_DataCtrl.GetWindowText(str,m_DataCtrl.GetWindowTextLength()+1);
		int i=strlen(str);
		Data=str;
		m_Status=_itoa(i,m_data,10);
		UpdateData(FALSE);
		do{		
			if(i>8)
				s_Data=Data.Mid(m_count,8);
			else
				s_Data=Data.Right(i);
			sprintf(m_data,"%s",(LPCTSTR)s_Data);
			if(!CH365_CanBus_Send(iRegion,iSubId,iFunc,iExFunc,(UCHAR *)(m_data),m_FrameMode))
					MessageBox("Send Error !");

			i=i-8;	
			m_count=m_count+8;
			Sleep(20L);
		}while(i>0);

		m_DataCtrl.SetSel(0,-1);
	}
	else
	{
		MessageBox("Please Open The Device First!!");
	}
	// TODO: Add your control notification handler code here
}

void CCan_BusDlg::OnButtonClear() 
{
	// TODO: Add your control notification handler code here
	m_ListCtrl.ResetContent();
}
