/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

function nsCloseAllWindows() {
}

nsCloseAllWindows.prototype = {

    // This "class" supports nsICloseAllWindows, and nsISupports.
    QueryInterface: function (iid) {
        if (!iid.equals(Components.interfaces.nsICloseAllWindows) &&
            !iid.equals(Components.interfaces.nsISupports)) {
            throw Components.results.NS_ERROR_NO_INTERFACE;
        }
        return this;
    },

    // ---------- nsICloseAllWindows methods ----------

    // closeAll: Close all open windows
    closeAll: function(aAskToSave)  {
    
        var windowMediator = Components.classes['@mozilla.org/appshell/window-mediator;1'].
                                getService(Components.interfaces.nsIWindowMediator);
        var enumerator = windowMediator.getEnumerator(null);

        while (enumerator.hasMoreElements()) {
           var domWindow = enumerator.getNext();
           if (aAskToSave && ("tryToClose" in domWindow)) {
               if (!domWindow.tryToClose())
                   return false;
           }
           domWindow.close();
        };
    
        return true;
    }
}

// This Component's module implementation.  All the code below is used to get this
// component registered and accessible via XPCOM.
var module = {
    firstTime: true,

    // registerSelf: Register this component.
    registerSelf: function (compMgr, fileSpec, location, type) {
        if (this.firstTime) {
            this.firstTime = false;
            throw Components.results.NS_ERROR_FACTORY_REGISTER_AGAIN;
        }
        compMgr = compMgr.QueryInterface(Components.interfaces.nsIComponentRegistrar);
        compMgr.registerFactoryLocation( this.cid,
                                         "Close All Windows",
                                         this.contractId,
                                         fileSpec,
                                         location,
                                         type );
    },

    // getClassObject: Return this component's factory object.
    getClassObject: function (compMgr, cid, iid) {
        if (!cid.equals(this.cid)) {
            throw Components.results.NS_ERROR_NO_INTERFACE;
        }

        if (!iid.equals(Components.interfaces.nsIFactory)) {
            throw Components.results.NS_ERROR_NOT_IMPLEMENTED;
        }

        return this.factory;
    },

    /* CID for this class */
    cid: Components.ID("{2f977d48-5485-11d4-87e2-0010a4e75ef2}"),

    /* Contract ID for this class */
    contractId: "@mozilla.org/appshell/closeallwindows;1",

    /* factory object */
    factory: {
        // createInstance: Return a new nsCloseAllWindows object.
        createInstance: function (outer, iid) {
            if (outer != null)
                throw Components.results.NS_ERROR_NO_AGGREGATION;

            return (new nsCloseAllWindows()).QueryInterface(iid);
        }
    },

    // canUnload: n/a (returns true)
    canUnload: function(compMgr) {
        return true;
    }
};

// NSGetModule: Return the nsIModule object.
function NSGetModule(compMgr, fileSpec) {
    return module;
}
