/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */



const Cc = Components.classes;
const Ci = Components.interfaces;
const Cr = Components.results;

function LOG(str) {
  dump("*** " + str + "\n");
}

const TYPE_MAYBE_FEED = "application/vnd.mozilla.maybe.feed";
const PREF_SELECTED_WEB = "browser.feeds.handlers.webservice";

const TYPETYPE_MIME = 1;
const TYPETYPE_PROTOCOL = 2;




var gAddFeedReader = {
  _result: null,
  _uri: null,
  _title: null,
  _type: null,
  _typeType: null,
  _handlerInstalled: false,

  init: function AFR_init() {
    this._result = window.arguments[0].QueryInterface(Ci.nsIDialogParamBlock);
    this._uri = window.arguments[1].QueryInterface(Ci.nsIURI);
    this._title = window.arguments[2];
    this._type = window.arguments[3];
    this._typeType = window.arguments[4];
  
    var strings = document.getElementById("strings");
    var dlg = document.documentElement;
    var addQuestion = document.getElementById("addQuestion");

    var wccr = 
        Cc["@mozilla.org/embeddor.implemented/web-content-handler-registrar;1"].
        getService(Ci.nsIWebContentConverterService);
    var handler = 
        wccr.getWebContentHandlerByURI(this._type, this._uri.spec);
    this._handlerInstalled = handler != null;

    var key = this._handlerInstalled ? "handlerRegistered" : "addHandler";
    var message = strings.getFormattedString(key, [this._title]);
    addQuestion.setAttribute("value", message);
    
    if (this._type != TYPE_MAYBE_FEED && this._typeType == TYPETYPE_MIME) {
      var mimeService = 
          Cc["@mozilla.org/uriloader/external-helper-app-service;1"].
          getService(Ci.nsIMIMEService);
      var ext = mimeService.getPrimaryExtension(this._type, null);
      var imageBox = document.getElementById("imageBox");
      imageBox.style.backgroundImage = "url('moz-icon://goat." + ext + "?size=32');";
    }

    document.getElementById("site").value = this._uri.host;
    
    if (handler) {
      dlg.getButton("cancel").hidden = true;
      dlg.defaultButton = "accept";
      document.getElementById("siteBox").hidden = true;
    }
    else {
      dlg.getButton("accept").label = strings.getString("addHandlerYes");
      dlg.getButton("cancel").label = strings.getString("addHandlerNo");
    }

    window.sizeToContent();
  },

  onDialogAccept: function AFR_onDialogAccept() {
    // Used to tell the WCCR that the user chose to add the handler (rather 
    // than canceling).
    const PARAM_SHOULD_ADD_HANDLER = 0;

    // We don't need to add an already-installed handler
    this._result.SetInt(PARAM_SHOULD_ADD_HANDLER, !this._handlerInstalled);
  }
};
