/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
*/


const nsIDialogParamBlock = Components.interfaces.nsIDialogParamBlock;
const nsIPKIParamBlock    = Components.interfaces.nsIPKIParamBlock;
const nsIX509Cert         = Components.interfaces.nsIX509Cert;

var dialogParams;
var pkiParams;
var cert=null;

function onLoad()
{
  pkiParams    = window.arguments[0].QueryInterface(nsIPKIParamBlock);
  dialogParams = pkiParams.QueryInterface(nsIDialogParamBlock);

  document.title = dialogParams.GetString(2);
  var bundle = srGetStrBundle("chrome://pippki/locale/pippki.properties");
  var message1 = dialogParams.GetString(1);
  
  var currDate = new Date(); 
  var message2 = bundle.formatStringFromName("serverCertExpiredMsg2", 
                                             [ currDate.toLocaleString() ],
                                              1);
  setText("message1", message1);
  setText("message2", message2);
  document.documentElement.getButton("accept").focus();
}

function doOK()
{
  dialogParams.SetInt(1,1);
  return true;
}

function doCancel()
{
  dialogParams.SetInt(1,0);
  return true;
}

function viewCert()
{
  if (cert == null) {
    var isupport = pkiParams.getISupportAtIndex(1);
    cert = isupport.QueryInterface(nsIX509Cert);
  }
  viewCertHelper(window, cert);
}
