REM phone book program
'
REM **** set up variables and screen ****
SCREEN #1 TEXT: WINDOW CURSOR ON: WINDOW FULL
limit = 100
DIM names$(limit),phone$(limit)
phone_file$ = "phone.seq": file = 6
file_changed = FALSE
CLS
PRINT "Phone book"
'
 REM **** get data ****
GOSUB readfile
'
REM **** get and obey commands ****
REPEAT
  CLS
  PRINT "Phone book ";entries;" entries"
  PRINT:PRINT "Search for number, Add a number or Finish (S/A/F) ";
  template$="SAF": GOSUB match
  command$ = answer$
  IF command$="S" THEN GOSUB searchentry: GOSUB keywait ELSE IF command$="A" THEN GOSUB addentry: GOSUB keywait
UNTIL command$ = "F"
'
REM **** finish ****
IF file_changed THEN GOSUB writefile
END
'
REM * * * * * *  SUBROUTINES * * * * * *
'
LABEL readfile
  entries = 0: got_file = FALSE: answer$=""
  REM ** check if file there **
  REPEAT
    IF FIND$(phone_file$) <> "" THEN got_file = TRUE ELSE GOSUB file_not_found
  UNTIL (answer$ = "N") OR got_file
  IF NOT got_file THEN RETURN
  REM * file found so read entries *
  PRINT: PRINT "Reading phone book: please wait"
  OPEN #file INPUT phone_file$
  WHILE NOT(EOF(#file))
    entries = entries + 1
    INPUT #file,names$(entries)
    INPUT #file,phone$(entries)
  WEND
  CLOSE #file
RETURN

LABEL file_not_found
    REM * no file *
    PRINT "No phone book file on this disc."
    PRINT "Change disc or start New phone book on this disc (C/N)? ";
    template$="CN": GOSUB match
    IF answer$ = "C" THEN GOSUB changedisc
RETURN
'
LABEL searchentry
  IF entries = 0 THEN PRINT "Phone book empty!!!": RETURN
  INPUT "Type name to search for, then RETURN: ",search$
  search$ = UPPER$(search$)
  count = 1
  WHILE (count <= entries) AND (names$(count) <> search$)
    count = count + 1
  WEND
  IF count > entries THEN PRINT search$;" not found" ELSE PRINT "Phone number: ";phone$(count)
RETURN
'
LABEL addentry
  IF entries >= limit THEN PRINT "No room!!!": RETURN
  INPUT "Type name to add followed by RETURN:   ",id$
  INPUT "Type number to add followed by RETURN: ",phone$
  entries = entries + 1
  names$(entries) = UPPER$(id$)
  phone$(entries) = phone$
  file_changed = TRUE
RETURN
'
LABEL writefile
  PRINT: PRINT "Writing phone book: please wait"
  OPEN #file OUTPUT phone_file$
  FOR count = 1 TO entries
    PRINT #file,names$(count)
    PRINT #file,phone$(count)
  NEXT
  CLOSE #file
RETURN
'
LABEL changedisc
  RESET
  INPUT "Insert phone book disc then press RETURN",a$
RETURN
'
LABEL match
  REPEAT
    REPEAT
      answer$ = UPPER$(INKEY$)
    UNTIL answer$<>""
  UNTIL INSTR(template$,answer$) > 0
  PRINT
RETURN
'
LABEL keywait
  PRINT: PRINT "Press any key to continue"
  REPEAT
  UNTIL INKEY$ <> ""
RETURN
