/***************************************************************************** *

    RSH - remotely execute a UNIX command

    Copyright (C) 1999, Rod Whitby
    Copyright (C) 1991, University of Waterloo

    This program is free software; you can redistribute it and/or modify
    it, but you may not sell it.

    This program is distributed in the hope that it will be useful,
    but without any warranty; without even the implied warranty of
    merchantability or fitness for a particular purpose.

        Originally written by Erick Engelke

****************************************************************************** /
#include <time.h>		/* for randomize */
#include <stdlib.h>
#include <conio.h>		/* for getpass */
#include <stdio.h>
#include <string.h>
#include <tcp.h>

#define RSH_PORT 514

char cmdbuf[ 2048 ];
word cmdbuflen;

char lname[ 16 ];		/* local copies if none supplied */
char rname[ 16 ];
char lcmd[ 255 ];

void makecmdbuf( char *local, char *remote, char *cmd )
{
    char *p,*r;
    char *q = strrchr(cmd, '&');
    p = cmdbuf;
    *p++ = 0;
    strcpy( p, local );
    p = strchr( p, 0 );
    strcpy( ++p, remote );
    p = strchr( p, 0 ); p++;
    r = p;
    if (q) {
      strcpy( p, "sh -c \"" );
      p = strchr( p, 0 );
    }
    strcpy( p, cmd );
    if (q) {
      p = strrchr( p, '&' );
      strcpy( p, " </dev/null >/dev/null 2>&1 &\"" );
    }
    p = strchr( p, 0 );

    cmdbuflen = (word)(p - cmdbuf) + 1;

    printf("%s\n", r);

    return; 
}

int rsh( char *hostname, word port, char *local, char *remote, char *cmd )
{
    word lport, count;
    int status;
    longword host;
    char buffer[ 1024 ];
    static tcp_Socket rsh_sock;


    randomize();
    lport = (rand() & 512) + 512;	/* return 511 < port < 1024 */

    if (!(host = resolve( hostname ))) {
	printf("Unable to resolve '%s'\naborting\n", hostname );
	return( 2 );
    }

    if ( !local ) {
        printf(" Userid   : ");
	gets( local = lname );
	if ( !*local ) {
	    printf( local = "anonymous");
	}
    }
    if ( !remote ) {
	    strcpy( remote = rname, local);
	     /* copy for neatness since getpass overwrites */
    }
    if (!cmd) {
        printf(" Command  : ");
        gets( cmd = lcmd );
        if ( !*cmd ) {
            puts("No command given\n");
            exit( 2 );
        }
    }

    makecmdbuf( local, remote, cmd);

    if (! tcp_open( &rsh_sock, lport, host, port, NULL )) {
	printf("Remote host unaccessible");
	return( 1 );
    }
    fprintf(stderr, "waiting for remote host to connect...\r");
    sock_wait_established( &rsh_sock, sock_delay, NULL, &status );

    fprintf(stderr, "remote host connected, waiting verification...\r");

    sock_write( &rsh_sock, (byte*)cmdbuf, cmdbuflen );

    while (1) {
	sock_tick( &rsh_sock, &status );
	if (!sock_dataready(&rsh_sock))
	    continue;
	sock_fastread( &rsh_sock, (byte*)buffer, 1 );
	fprintf(stderr, "                                              \r");
	if ( *buffer == 1 )
	    fprintf(stdout, "RSH failed...\n\r");
	break;
    }

    while (1) {
	if (kbhit())
	    sock_putc( &rsh_sock, getch());
	sock_tick( &rsh_sock, &status );
	if (sock_dataready( &rsh_sock )) {
	    count = sock_fastread( &rsh_sock, (byte*)buffer, sizeof( buffer ));
	    fwrite( buffer , count, 1, stdout );
	}
    }

sock_err:
    switch (status) {
	case 1 : puts("\nConnection closed");
		 break;
        case-1 : printf("ERROR: %s\n", sockerr( &rsh_sock ));
		 break;
    }
    return( (status == 1) ? 0 : 1 );
}

void help( void )
{
    puts("LXRSH host [username] cmdstring");
    puts("The values for cmdstring should be placed inside quotes");
    exit( 3 );
}

int main( int argc, char **argv )
{
    char *hostname, *local, *remote, *cmd;

  printf("LXRSH %.1f", (double)VERSION/10);

  if (RELEASE > 0) {
    printf("b%d", RELEASE);
  }

  printf(" - %s <%s>\n",
         "HP200LX TCP/IP Suite",
         "http://lxtcp.hplx.net/");

    hostname = local = remote = cmd = NULL;

  if (getenv("LXTCP.CFG")) {
    tcp_config_file(getenv("LXTCP.CFG"));
  }

    sock_init();

    hostname = argv[ 1 ];

    switch ( argc ) {
        case  4 : local = argv[2];
        case  3 : cmd = argv[ argc - 1 ];
                  break;
        case  2 : break;
        default : help();
    }

    exit( rsh( hostname, RSH_PORT, local, remote, cmd ));
    return (0);  /* not reached */
}
