/* $Id: VSINTERF.C 1.3 1999/01/09 06:03:29 rwhitby Exp $ */
/* $Source: A:/SRC/TCP/NCSATCP/SRC/RCS/VSINTERF.C $ */

/*
 * Portions developed by the Educational Resources Center, Clarkson University.
 * Portions developed by the National Center for Supercomputing Applications,
 * University of Illinois at Urbana-Champaign.
 */

/*
 *
 *	  Virtual Screen Kernel Interface
 *			  (vsinterf.c)
 *
 *	  by Gaige B. Paulsen
 *
 *	This file contains the control and interface calls for the NCSA
 *  Virtual Screen Kernal.
 *
 *	  VSinit(maxwidth)					- Initialize the VSK
 *	  VSnewscreen(maxlines,scrnsave)	- Initialize a new screen.
 *	  VSdetatch(w)						- Detach screen w
 *	  VSredraw(w,x1,y1,x2,y2)			- redraw region for window w
 *	  VSwrite(w,ptr,len)				- write text @ptr, length len
 *	  VSclear(w)						- clear w's real screen
 *	  VSkbsend(w,k,echo)				- send keycode k's rep. out window w (w/echo if req.)
 *	  VSclearall(w)						- clear w's real and saved screen
 *	  VSreset(w)						- reset w's emulator (as per TERM)
 *	  VSgetline(w,y)					- get a ptr to w's line y
 *	  VSsetrgn(w,x1,y1,x2,y2)			- set local display region
 *	  VSscrolback(w,n)					- scrolls window w back n lines
 *	  VSscrolforward(w,n)				- scrolls window w forward n lines
 *	  VSscrolleft(w,n)			 		- scrolls window w left  n columns
 *	  VSscrolright(w,n)			 		- scrolls window w right n columns
 *	  VSscrolcontrol(w,scrlon,offtop)	- sets scroll vars for w
 *	  VSgetrgn(w,&x1,&y1,&x2,&y2)		- returns set region
 *	  VSsnapshot(w)				  		- takes a snapshot of w
 *	
 *		Version Date	Notes
 *		------- ------  ---------------------------------------------------
 *		0.01	861102  Initial coding -GBP
 *		0.10	861113  Added some actual program to this file -GBP
 *		0.15	861114  Initiated Kludge Operation-GBP
 *		0.50	861123  Parameters added to VSnewscreen -GBP
 *		0.90	870203	Added the kbsend routine -GBP
 *		2.1		871130	NCSA Telnet 2.1 -GBP
 *		2.2 	880715	NCSA Telnet 2.2 -GBP
 *
 */

#include <stdio.h>

#include "config.h"
#include "mem.h"
#include "newwin.h"
#include "windat.h"
#include "vsdata.h"
#include "vskeys.h"
#include "vsinit.h"

extern int VSmax,VSinuse;  /* Internal variables for use in managing windows */
extern VSscrndata *VSscreens;


VSwrite(w,ptr,len)
     int w,len;
     char *ptr;
{
  int i;

  if (VSvalids(w)!=0) return(-3);
  VSIcuroff(w);
  i = VSem(ptr,len);
  VSIcurson(w,VSIw->x,VSIw->y, 1); /* Force Move */
  return(i);
}

/* End of vsinterf.c */
