/* $Id: PCUTIL.C 1.9 1999/05/22 11:49:31 rwhitby Exp $ */
/* $Source: A:/SRC/TCP/NCSATCP/SRC/RCS/PCUTIL.C $ */

/*
 * Portions developed by the Educational Resources Center, Clarkson University.
 * Portions developed by the National Center for Supercomputing Applications,
 * University of Illinois at Urbana-Champaign.
 */

#include <alloc.h>
#include <conio.h>
#include <ctype.h>
#include <dir.h>
#include <dos.h>
#include <io.h>
#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

#include "config.h"
#include "protocol.h"
#include "windat.h"
#include "newwin.h"
#include "hostform.h"
static struct ffblk fblock;
#include "mem.h"

extern struct config Scon;
extern char myuser[17];

/**********************************************************************/
/*
*   Find directory name -- return a code that indicates whether the
*   directory exists or not.
*   0 = dir name ok
*   -1 = error
*   > 0 = dos error code, no dir by this name
*
*   Accept certain unix conventions, like '/' for separator
*
*   Also, append a '\' to the name before returning
* 
*  Note:  There must be enough room in the string to append the '\'
*/

struct dosdta {
	char junk[21];
	char att;
	int time,date;
	long int size;
	char name[13];
};

extern struct dosdta *dtaptr;

direxist(dirname)
	char dirname[];
	{
	int i,ret;
	char *p;

	if (!strcmp(dirname,".") || !dirname[0]) {
		dirname[0] = '\0';
		return(0);
	}

	if (!strcmp(dirname,"\\"))
		return(0);

	p = dirname;
	while (*p) {
		switch (*p) {
			case '*':
			case '?':
				return(-1);
			case '/':
				*p = '\\';
			default:
				break;
		}
		p++;
	}

/*
*  n_findfirst  will return normal files AND directories
*  must check attribute to see if it is really a directory
*/
	ret = n_findfirst(dirname,0x10);		/* find name */

	if (ret)
		return(ret);

	if (!(dtaptr->att & 0x10))
		return(-2);							/* is a normal file */

	i = strlen(dirname);
	dirname[i] = '\\';						/* extend with '\' */
	dirname[++i] = '\0';
	
	return(0);
}


char
*ffparse(struct ffblk *f, int mode)               /* parse out this sucker */
{
        static char name[13];
        static char buff[80];
        int     x;
        struct ftime *ft;
	struct tm *lt;
	time_t now;

	static char *months[] = {
	  "Jan", "Feb", "Mar", "Apr", "May", "Jun",
	  "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
	};

	sprintf(name, "%-12.12s", f->ff_name);

	for (x=0; x < strlen(name); x++) {
	  name[x] = isupper(name[x]) ? tolower(name[x]) : name[x];
	  if (name[x] == ' ') name[x] = 0;
	}
	
	if (mode) {
	  return(name);
	}
	else {
	  ft = (struct ftime *) &f->ff_ftime;
	  now = time(NULL);
	  lt = localtime(&now);
	  
	  sprintf(buff, "%c%c%c%c%c%c%c--- %3d %-8s %-8s %7ld %3s %02d",
		  (f->ff_attrib & FA_DIREC ? 'd' : '-'), 'r',
		  (f->ff_attrib & FA_RDONLY ? '-' : 'w'),
		  (f->ff_attrib & FA_SYSTEM ? 's' :
		   (f->ff_attrib & FA_DIREC ? 'x' : '-')),
		  (f->ff_attrib & FA_HIDDEN ? '-' : 'r'),
		  (f->ff_attrib & FA_HIDDEN ? '-' :
		   (f->ff_attrib & FA_RDONLY ? '-' : 'w')),
		  (f->ff_attrib & FA_HIDDEN ? '-' :
		   (f->ff_attrib & FA_DIREC ? 'x' : '-')),
		  1, myuser, myuser,
		  f->ff_fsize, months[ft->ft_month-1], ft->ft_day);

	  /* Use much the same algorithm as Unix to determine whether
	     to show the time or the year.  People who want to know
	     both can always use the MDTM command to get all the
	     details. */

	  if ((((ft->ft_year + 80) * 12 + (ft->ft_month - 1)) <
	       (lt->tm_year * 12 + lt->tm_mon - 6)) ||
	      (((ft->ft_year + 80) * 12 + (ft->ft_month - 1)) >
	       (lt->tm_year * 12 + lt->tm_mon + 6))) {
	    sprintf(buff+strlen(buff), "  %04d", ft->ft_year+1980);
	  }
	  else {
	    sprintf(buff+strlen(buff), " %02d:%02d", ft->ft_hour, ft->ft_min);
	  }
	  sprintf(buff+strlen(buff), " %s", name);
	  return(buff);
	}
}

char
*fixslash(str)                  /* change \ to / */
     char *str;
{
  char *c;

  c = str;

  while(*c) {
    if (*c == '\\')  *c = '/';
    if (isupper(*c)) *c = tolower(*c);
    if (*c == ' ')   return(str);
    c++;
  }
  
  return(str);
}

/**********************************************************************/
/* firstname
 *  find the first name in the given directory which matches the wildcard
 *  specification
 *
 *  must malloc enough space for the path plus a full filename
 *
 *  expand '*' (unix) to '*.*' (dos)
 */
static char *savepath;
static int rootlen;

char *firstname(path,mode)
     char path[];
     int     mode;
{
  int i,len;
  char *p,*q;

  if (!*path)
    return(NULL);

  len = strlen(path);
  savepath = mem_malloc(len + 80);
  i = 0;
  rootlen = 0;
  q = savepath;
  p = path;
  while (*q = *p) {			/* basic string copy with extras */
    if (*p == '\\')
      rootlen = i+1;			/* rootlen = position of last \ */
    p++;
    q++;
    i++;
  }

  if (savepath[len-1] == '*' && rootlen == len-1) {
    savepath[len++] = '.';
    savepath[len++] = '*';
    savepath[len++] = '\0';
  }

  if (findfirst(savepath, &fblock, FA_HIDDEN|FA_SYSTEM|FA_DIREC))
    return(NULL);

  strcpy(&savepath[rootlen], ffparse(&fblock, mode));
                
  if (mode) {
    return(fixslash(savepath));
  }
  else {
    return(fixslash(&savepath[rootlen]));
  }
}

/**********************************************************************/
/* nextname
 *  modify the path spec to contain the next file name in the
 *  sequence as given by DOS
 *
 *  if at the end of the sequence, return NULL
 */
char *nextname(mode)
     int     mode;
{
  char *p,*q;

  if (NULL == savepath)
    return(NULL);

  if(findnext(&fblock)) {
    mem_free(savepath);
    savepath = NULL;
    return NULL;
  }
  else {
    strcpy(&savepath[rootlen], ffparse(&fblock, mode));
    if (mode) {
      return(fixslash(savepath));
    }
    else {
      return(fixslash(&savepath[rootlen]));
    }
  }
}

/**********************************************************************/
/*  dopwd
 *   get the current directory, including disk drive letter
 */
dopwd(p,l)
     char *p;
     int l;
{
  getcwd(p,l-2);				/* get dir */

}

/**********************************************************************/
/*  chgdir
 *  change directory, including disk drive letter
 */

chgdir(d)
     char *d;
{
  int len;

  while (*d && *d < 33)
    d++;

  if (!(*d))
    return(-1);

  *d = toupper(*d);

  if (*(d+1) == ':') {
    setdisk((*d)-'A');
    d += 2;
  }

  if (!(*d))
    return(0);				/* just changed disk */

  len = strlen(d);

  /* Remove any trailiing \ (but leave a single \ alone) */
  if ((len > 1) && (*(d+len-1) == '\\')) {
    *(d+len-1) = 0;
  }

  return(chdir(d));

}


status_setup()                  /* setup for status */
{
  unsigned long *x;
  unsigned int count, limit;


  limit = (_SP - 32)/sizeof(long) - 256;

  x = MK_FP(_SS,256);

  for(count=0; count < limit; count++)
    *(x++) = 0xFFFFFFFF;

}


program_status()                /* display status about this machine */
{
  extern unsigned _stklen, _ovrbuffer, _heapbase,_heaptop;
#ifdef	OVERLAY
  extern unsigned _ovrsize;
#else
  unsigned _ovrsize = 0;
#endif
  unsigned long *x;
  int count,color,i;
  long perc,mem,z;
  unsigned k;
  char buff[20],*c;
  struct machinfo *m;

  k = _SS;
  x = MK_FP(k,256);
  count = 256;
  while(*(x++) == 0xFFFFFFFF)
    count++;

  color = n_color(7); 
  count *= 4;

  n_clear();
  n_cur(0,0);

  nprintf(SCREEN,"Network Status\n\n");
  nprintf(SCREEN,"ip           = %d.%d.%d.%d\n",
	  Scon.myipnum[0], Scon.myipnum[1], Scon.myipnum[2], Scon.myipnum[3]);
  nprintf(SCREEN,"netmask      = %d.%d.%d.%d\n",
	  Scon.netmask[0], Scon.netmask[1], Scon.netmask[2], Scon.netmask[3]);
  nprintf(SCREEN,"hostname     = %s\n", Scon.hostname);
  nprintf(SCREEN,"domainslist  = %s\n", Scon.domainpath);
  i = 1;
  while ((m = Slooknum(i)) != NULL) {
    if (m->mstat >= HAVEIP) {
      if (m->gateway) { 
	nprintf(SCREEN,"gateway      = %d.%d.%d.%d\n",
		m->hostip[0], m->hostip[1], m->hostip[2], m->hostip[3]);
      }
      if (m->nameserv) { 
	nprintf(SCREEN,"nameserver   = %d.%d.%d.%d\n",
		m->hostip[0], m->hostip[1], m->hostip[2], m->hostip[3]);
      }
    }
    i++;
  }
  nprintf(SCREEN,"\n");
  
  nprintf(SCREEN,"Program Status\n\n");
  k = _stklen - count;
  perc  = (k * 100L)/_stklen;
  nprintf(SCREEN,"Resident Code and Stubs    = %6ld  -- DS %04x - PSP %04x\n",
	  mem = (long) (_DS - _psp) * 16L,_DS, _psp);
  nprintf(SCREEN,"Dgroup Segment Size        = %6ld  -- SS %04x - DS  %04x\n",
	  z = (long) (_SS -_DS) * 16L,_SS, _DS);
  mem += z;
  nprintf(SCREEN,"Stack length               = %6u  -- Max Used %u (%d%%)\n", _stklen,k,perc );
  mem += _stklen;
  /*   nprintf(SCREEN,"Current SP %04x  %u Bytes  %d%%\n",_SP,_SP, 100 * (_stklen - _SP)/_stklen); */
  nprintf(SCREEN,"Overlay Buffer Size        = %6u  -- Requested Size %u\n",_ovrsize,_ovrbuffer * 16);
  mem += _ovrsize;
  c = mem_malloc(1);
  k = _SS + (_stklen/16) + (_ovrsize/16);
  nprintf(SCREEN,"Dynamic Memory Used        = %6ld\n", z = (long) (FP_SEG(c) - k) * 16);
  nprintf(SCREEN,"%*.*s-----------\n",28,28," ");
  mem += z;
  nprintf(SCREEN,"Total Memory Used          = %6ld bytes\n\n",mem);
  mem_free(c);
  nprintf(SCREEN,"Remaining Free Memory      = %6ld bytes\n",coreleft());
#ifdef	MEM_DEBUG
  nprintf(SCREEN,"mem_check...");
  mem_check();
  nprintf(SCREEN,"ok\n");
#endif
  n_color(color);

}

LoadInit(struct twin *tw)	/* initialize load display */
{
	char	buff[80];

	sprintf(buff,"%c[2J%c[H             KBytes Received\n\r             KB/Second",27,27);
	VSwrite(tw->vs,buff,strlen(buff));
	tw->bytes = 0L;
}

LoadWrite(struct twin *tw, char *dat, int len)
{
 	char	buff[80];
	unsigned long	throughput;
	unsigned long	diff;
	long	now;
static	long	lastupdate;

	if(!tw->bytes)
	   	tw->starttime = time(NULL);
	tw->bytes += len;
	now = time(NULL);
	if(lastupdate != now)  {
	   	diff = now - tw->starttime;
		lastupdate = now;
		if(diff)   {
			throughput = (tw->bytes)/1024;
			sprintf(buff,"%c[H% 3ld.%2d \n\r% 3ld.%2d ",27,throughput,
			       	(unsigned int) (tw->bytes % 1024),
				 (unsigned long) throughput/diff,
				  (unsigned int) (throughput % diff));
			VSwrite(tw->vs,buff,strlen(buff));
		}
	}

}


long
freediskspace()		/* returns free space on current drive */
{

      struct dfree t;
	long count;

	getdfree(0, &t);

	count = (long) t.df_avail * (long) t.df_bsec * (long) t.df_sclus;
	return(count);
	return(-1);
}

#ifdef	TRASH
int
cprintf(char *format,...)
{
	va_list list;
	char	tbuff[256],xbuff[256],*c,*o;
	int	len;

	c = xbuff;
	o = format;
	while(*o) {
	       if(*o == '\n')
		      	*c++ = '\r';
		*c++ = *o++;
	}
	*c++ = 0;
	va_start(list,format);
	vsprintf(tbuff,xbuff,list);
	va_end(list);
	vprint(console->vs,tbuff);
	return(0);
}

#endif

/* End of pcutil.c */
