;/* cu-notic.txt         NCSA Telnet version 2.2C     2/3/89
;   Notice:
;        Portions of this file have been modified by
;        The Educational Resources Center of Clarkson University.
;
;        All modifications made by Clarkson University are hereby placed
;        in the public domain, provided the following statement remain in
;        all source files.
;
;        "Portions Developed by the Educational Resources Center, 
;                Clarkson University"
;
;        Bugs and comments to bkc@omnigate.clarkson.edu
;                                bkc@clgw.bitnet
;
;        Brad Clements
;        Educational Resources Center
;        Clarkson University
;*/


;
;  ncsaio.asm
;  Support for BIOS calls in NCSA Telnet
;****************************************************************************
;*                                                                          *
;*                                                                          *
;*      part of NCSA Telnet                                                 *
;*      by Tim Krauskopf, VT100 by Gaige Paulsen, Tek by Aaron Contorer     *
;*                                                                          *
;*      National Center for Supercomputing Applications                     *
;*      152 Computing Applications Building                                 *
;*      605 E. Springfield Ave.                                             *
;*      Champaign, IL  61820                                                *
;*                                                                          *
;*                                                                          *
;****************************************************************************

	TITLE	NCSAIO    -- LOW-LEVEL I/O FOR SANE HARDWARE HANDLING
ifdef   TURBOC
Microsoft       EQU     1
else
Lattice EQU 1
endif

  ifndef Microsoft
    ifndef Lattice
      if2
        %out
        %out ERROR: You have to specify "/DMicrosoft" OR "/DLattice" on the
        %out        MASM command line to determine the type of assembly.
        %out
      endif
      end
    endif
  endif

;
;   From original code by Tim Krauskopf    1984-1985
;
;   Modified and ported to Lattice C, Sept. 1986
;   ifdefs for Microsoft C, June 1987
;   Tim Krauskopf
;
;   National Center for Supercomputing Applications
;
	NAME	NIO

;
;  Macros for reading and writing I/O ports
;
MOUT	MACRO	REG,STUFF       ; one byte to the given I/O register
	MOV	DX,REG
	MOV	AL,STUFF
	OUT	DX,AL
	ENDM
;
MIN	MACRO	REG         	; get one byte to al
	MOV	DX,REG
	IN	AL,DX
	ENDM
;
;  Internal data 
;
;	X EQU	6				;  for the large model programs
        NUMLINES equ 41
ifdef junk
        extrn _sprintf:far
endif
	INCLUDE	DOS.MAC
	DSEG
	SETX

ifdef Microsoft
;DGROUP	group	_DATA
;_DATA	segment	public 'DATA'
;	assume	DS:DGROUP

	public _dtaptr				; pointer to dta location
_dtaptr	dw	0000h				; DTA address for me
_dtads	dw	0000h				; DS for DTA
else
	public	dtaptr				; pointer to dta location

dtaptr	dw	0000h				; DTA address for me
dtads	dw	0000h				; DS for DTA
endif
        public  _botl
	public	_kbcodes, _rows, _cols, _dotop,_att,_regen

_att		db	7					; current default attribute
topl	db	00					; top line of current window
_botl	db	NUMLINES+1					; bottom line of current window
leftc	db	00					; left side of current window
rightc	db	79					; right side of current window
row		db	00					; cursor position row
col		db	00					; cursor position col
_cols		db	80					; number of physical cols
_rows		db	25					; number of physical rows
wrap	db	00					; wrap at end or not
_regen	dw	0b000h				; default to color screen
topoff	dw	0				; offset of topview segment
_dotop	db	0				; set if we should do topview
_kbcodes	dw	80H
keycode	dw	0
	; Aliaskey: keys having aliases - same ascii code but more than one
	; scan code, as on auxillary keypads. Use just scan codes with these.
	; Alternative use: force ascii keys to report out just scan codes.
	; Table format: high byte = scan code, low byte = ascii code. 
	; Contents are machine dependent.
scan	equ	100h			; keycode flag: code is scan not ascii
	public aliaskey
aliaskey dw	(14*scan)+8 ; bs		; Backspace key [hi=scan, lo=ascii]
	dw	(55*scan)+'*'		; keypad asterisk
	dw	(74*scan)+'-'		; keypad minus
	dw	(78*scan)+'+'		; keypad plus
	dw	(71*scan)+'7'		; keypad numeric area
	dw	(72*scan)+'8'
	dw	(73*scan)+'9'
	dw	(75*scan)+'4'
	dw	(76*scan)+'5'
	dw	(77*scan)+'6'
	dw	(79*scan)+'1'
	dw	(80*scan)+'2'
	dw	(81*scan)+'3'
	dw	(82*scan)+'0'
	dw	(83*scan)+'.'
	dw	(83*scan)+','		; German keypad had comma vs dot
	dw	(15*scan)+9 ; tab
	dw	(28*scan)+13 ; cr		; typewriter Enter key
aliaslen equ	($-aliaskey) shr 1	; number of words in aliaskey table


        public _extended
_extended       dw      0
getc        db   0        ;code for reading a character
checkc	    db    1        ;code for keyboard status
checkstat	    db	2		; extended keyboard status
;
;    In this implementation, all special and function keys are translated
;    to the following values.
;
comment |
tr	db	3 dup (0)
	db  0dbh
	db  11 dup(0)
	db	08fh,0d1h,0d7h,0c5h,0d2h,0d4h,0d9h,0d5h,0c9h,0cfh,0d0h
	db	4 dup(0)
	db	0c1h,0d3h,0c4h,0c6h,0c7h,0c8h,0cah,0cbh,0cch
	db	5 dup(0)
	db	0dah,0d8h,0c3h,0d6h,0c2h,0ceh,0cdh
	db	8 dup(0)
	db	80h,81h,82h,83h,84h,85h,86h,87h,88h,89h
	db	0,0
	db	8ah,8dh,9ah,0,8bh,0,9bh,0,8ch,8eh,9ch,9dh,9eh
	db	90h,91h,92h,93h,94h,95h,96h,97h,98h,99h
	db	0a0h,0a1h,0a2h,0a3h,0a4h,0a5h,0a6h,0a7h,0a8h,0a9h
	db	0e0h,0e1h,0e2h,0e3h,0e4h,0e5h,0e6h,0e7h,0e8h,0e9h
	db	0aeh,0abh,0bbh,0ach,0bch,0aah
	db	0b0h,0b1h,0b2h,0b3h,0b4h,0b5h,0b6h,0b7h,0b8h,0b9h
	db	0bdh,0beh,0bah
        db      0eah,0ebh,0ech,0edh,0efh,0f0h,0f1h,0f2h ; F11,F12,SF11,SF12,CF11,CF12,AF11,AF12
                                                        ; only on extended keyboards
	db  115 dup(0)
|
ifdef   junk
printme db      '%04x',0
buffer  db      '       '
endif

ifdef Microsoftzz
_DATA	ends
else
	ENDDS
endif
;
;
;
;   The subroutines to call from C
;

ifdef Microsoft
;_TEXT	segment	public	'CODE'
	PSEG
	PUBLIC	_n_color,_n_upscroll,_n_dnscroll,_n_wrap,_n_erase,_n_getchar, _n_which
	PUBLIC  _n_bioswrite
	PUBLIC  _n_cur,_n_vcur,_n_row,_n_col,_n_clear,_n_window,_n_putchar,_n_chkchar
	PUBLIC  _n_savewin,_n_restwin,_n_puts,_n_sound,_n_findfirst,_n_findnext
	PUBLIC  _n_draw,_n_scrup,_n_scrdn,_n_cheat,_n_scrlck,_n_clicks,_n_chkstat, _n_bordcol
	assume CS:_TEXT, DS:DGROUP
else
	PSEG

	PUBLIC	n_color,n_upscro,n_dnscro,n_wrap,n_erase,n_getcha, n_which
	PUBLIC  n_cur,n_row,n_col,n_clear,n_window,n_putcha,n_chkcha
	PUBLIC  n_savewi,n_restwi,n_puts,n_sound,n_findfi,n_findne
	PUBLIC  n_draw,n_scrup,n_scrdn,n_cheat,n_scrlck,n_clicks,n_chkstat, n_bordcol
endif


_n_write_string	proc	far
	push	bp
	mov	ah, 2
	int	10H
looppy:
	push	cx
	mov	cx,1 
	mov	ah, 9
	mov	al,20H
	int	10H			; display space w/ attribute
	pop	cx
	mov	al, byte ptr es:[bp]
	mov	ah, 0eH;
	int	10H
	inc	bp
	loop	looppy
exitme:
	pop	bp
	ret
_n_write_string	endp


;/***************************************************************/
; scrlck
;   returns whether scroll lock is on or not
;
ifdef Microsoft
_n_scrlck	proc	far
else
n_scrlck	proc	far
endif
		push bp
		xor		ax,ax
		mov		ah,byte ptr _kbcodes
		inc		ah
		int		16h				; keyboard int
		and		al,010h			; scroll lock state bit
		xor		ah,ah
		pop bp
		ret	
ifdef Microsoft
_n_scrlck	endp
else
n_scrlck	endp
endif


;/***************************************************************/
;
;   Change the value of my current color
;
ifdef Microsoft
_n_color	proc	far
else
n_color	proc	far
endif
		push	bp
		mov		bp,sp
		xor		ax,ax
		mov		dl,[bp+x]			; parameter, one byte
		mov		al,_att				; return old color
		mov		_att,dl
		pop		bp
		ret
ifdef Microsoft
_n_color	endp
else
n_color	endp
endif

ifdef	Microsoft
_n_bordcol	proc	far
else
n_bordcol	proc	far
endif
	push	bp
	mov	bp,sp
	push	si
	push	di
	xor	bx,bx
	mov	bl, [bp+x]
	mov	ah, 0bH
	int	10h
	pop	di
	pop	si
	pop	bp
	ret
ifdef	Microsoft
_n_bordcol	endp
else
n_bordcol	endp
endif


;/*****************************************************************/
;   Determine the current type of display
;
;   ask the BIOS which screen is currently active THIS ALSO SETS extended keyboard
;
ifdef Microsoft
_n_which	proc	far
else
n_which	proc	far
endif
	push bp

; EXTENDED KEYBOARD CHECK  bkc 3/9/89
        cmp     _extended,0
        jne     notextended
	mov	ax, 40H
	mov	es, ax
	mov	ax, es:[96h]
	and	ax, 10H
	jz	notextended
        mov     getc, 010H
        mov     checkc, 011H
	mov	checkstat, 012H
        mov     _extended, 010H
notextended:
	mov	ah,15			; get screen mode
	int	10h				; call video BIOS
	cmp	al,7			; is it mono?
	jz	K1				; yes
    mov ax,0b800h		; no, set for color
    jmp K2
K1: mov ax,0b000h
K2: 

; now some extra gunk for topview
	push	di
	push	ax
	mov	es, ax
	xor	di,di
	mov	ah, 0FEH		; get topview segment
	int	10H
	mov	ax,es
	mov	dx,ax
	pop	ax
	cmp	ax,dx
	je	K99
K98:
	mov	_dotop,1
	mov	ax, es
	mov	topoff, di
	jmp	K100
K99:
	cmp	di,0
	jne	K98
K100:
	pop	di
	mov  _regen,ax
	push	es
	mov	ax, 40H
	mov	es, ax
	mov	ax, word ptr es:[4AH]	; get cols on screen
	mov	_cols, al
	mov	rightc, al
	mov	ax, word ptr es:[84H];
	cmp	al,24
	jge	K102
	mov	al,24
K102:
	cmp	al,60
	jl	K105
	mov	al,60
K105:
	mov	_botl,al
	inc	ax
	mov	_rows, al
	pop	es
	pop bp
    ret
ifdef Microsoft
_n_which	endp
else
n_which	endp
endif

;
;/***************************************************************/
;
;   Set whether word wrap will be on or not
;   usage:  n_wrap(flag);
;
ifdef Microsoft
_n_wrap	proc	far
else
n_wrap	proc	far
endif
		push	bp
		mov		bp,sp
		mov		dl,[bp+x]			; parameter, one byte flag
		mov		al,wrap				; return old color
		mov		wrap,dl
		pop		bp
		ret
ifdef Microsoft
_n_wrap	endp
else
n_wrap	endp
endif

;/***************************************************************/
;
;   Move the cursor somewhere
;
ifdef Microsoft
_n_cur	proc	far
else
n_cur	proc	far
endif
		push	bp
		mov		bp,sp
		mov		dh,[bp+x]			; row position
		mov		dl,[bp+x+2]			; column position
		mov		row,dh				; save a copy for me
		mov		col,dl				; save column too
	    mov  	ax,0200h			; ah=2 function call
	    xor 	bx,bx				; video page 0
	    int  	10h      			; set cursor position
		pop		bp
		ret
ifdef Microsoft
_n_cur	endp
else
n_cur	endp
endif


ifdef Microsoft
_n_vcur	proc	far		; virtual cursor move
else
n_vcur	proc	far
endif
		push	bp
		mov		bp,sp
		mov		dh,[bp+x]			; row position
		mov		dl,[bp+x+2]			; column position
		mov		row,dh				; save a copy for me
		mov		col,dl				; save column too
		pop		bp
		ret
ifdef Microsoft
_n_vcur	endp
else
n_vcur	endp
endif


;/***************************************************************/
;
;  set the window boundaries
;
;  usage:  n_window(ulrow,ulcol,lrrow,lrcol);
;     sets window size for future operations.
;
;
ifdef Microsoft
_n_window	proc	far
else
n_window	proc	far
endif
		push	bp
		mov		bp,sp
		mov		al,[bp+x]			; upper left x
		mov		topl,al
		mov		al,[bp+x+2]			; column position
		mov		leftc,al			; save a copy for me
		mov		al,[bp+x+4]
		mov		_botl,al				; bottom row
		mov		al,[bp+x+6]
		mov		rightc,al			; keep this one too

ifdef Microsoft
		call	_n_which				; what kind of screen?
else
		call	n_which				; what kind of screen?
endif
		pop		bp
		ret
ifdef Microsoft
_n_window	endp
else
n_window	endp
endif


;/***************************************************************/
;
;  erase portion of the screen
;
;  usage:  n_erase(ulrow,ulcol,lrrow,lrcol);
;
;
ifdef Microsoft
_n_erase	proc	far
else
n_erase	proc	far
endif
		push	bp
		mov		bp,sp
		mov		ch,[bp+x]			; upper left x
		mov		cl,[bp+x+2]			; column position
		mov		dh,[bp+x+4]
		mov		dl,[bp+x+6]
		xor		ax,ax				; clear area
		mov		ah,6				; scroll up function
		mov		bh,_att				; attribute for erasing is same as print
		int		10h					; call BIOS

		pop		bp
		ret
ifdef Microsoft
_n_erase	endp
else
n_erase	endp
endif

;/***************************************************************/
;  scroll up and down
;  given the number of lines to scroll and the dimensions of the
;  box to scroll.
;  
ifdef Microsoft
_n_scrup	proc	far
else
n_scrup	proc	far
endif
		push	bp
		mov		bp,sp
		mov		ch,[bp+x+2]			; upper left x
		mov		cl,[bp+x+4]			; column position
		mov		dh,[bp+x+6]
		mov		dl,[bp+x+8]
		mov		al,[bp+x]			; number of lines to scroll
		mov		ah,6				; scroll up function
		mov		bh,_att				; attribute for blank line is same as print
		int		10h					; call BIOS

		pop		bp
		ret
ifdef Microsoft
_n_scrup	endp
else
n_scrup	endp
endif

ifdef Microsoft
_n_scrdn	proc	far
else
n_scrdn	proc	far
endif
		push	bp
		mov		bp,sp
		mov		ch,[bp+x+2]			; upper left x
		mov		cl,[bp+x+4]			; column position
		mov		dh,[bp+x+6]
		mov		dl,[bp+x+8]
		mov		al,[bp+x]			; number of lines to scroll
		mov		ah,7				; scroll down function
		mov		bh,_att				; attribute for blank line is same as print
		int		10h					; call BIOS

		pop		bp
		ret
ifdef Microsoft
_n_scrdn	endp
else
n_scrdn	endp
endif

;/***************************************************************/
; 
;  Find the cursor position, return the row value
;  
ifdef Microsoft
_n_row	proc	far
else
n_row	proc	far
endif
		push bp
	    mov ax,0300h    	        ;	video find cursor function
	    xor bx,bx
	    int 10h  		            ; find cursor
		mov		row,dh
		mov		col,dl				; save col for next routine
		xor		ax,ax
		mov		al,dh				; return row location
		pop bp
		ret
ifdef Microsoft
_n_row	endp
else
n_row	endp
endif

;/****************************************************************************/
  ;-----------------------------------------------------------
  ;  This routine was submitted by David T. Burhans, Jr.
  ;  It was obtained from an RBBS-PC electronic bulleton board 
  ;  dedicated to the "C" language [(703) 321-7003].
  ;-----------------------------------------------------------
  ;
  ; SOUND - This routine produces a tone of a specified frequency 
  ; and duration on the speaker.
  ; The frequency in Hertz is moved into DI (21 to 65535 Hertz) 
  ; and the duration in hundredths of a second, is moved into BX 
  ; (0 to 65535).
  ; The routine is called with the following sequence:
  ;
  ;        Unsigned        frequency, duration;
  ;
  ;       n_sound(frequency, duration);
  ;
ifdef Microsoft
;_n_sound	proc	far
begin n_sound
else
n_sound	proc	far
endif
       push     bp
       mov      bp,sp
       push     di
       mov      di,[bp+X]        ; Frequency
       mov      bx,[bp+X+2]      ; Duration
       cmp      di, 21          ; See if freq. is below minimum
       in	al, 61H	
	mov	ah,al
       jb       skippy              ; If less than limit, then
                                  ; clean up and return
       mov      al,0B6H           ; Write timer mode register
       out      43H, al
       mov      dx, 14H           ; Timer divisor =
       mov      ax, 4F38H         ; 1331000/Frequency
       div      di
       out      42H,al            ; Write timer 2 count low byte
       mov      al,ah
       out      42H,al            ; Write timer 2 count high byte
       in       al,61H            ; Get current Port B setting
       mov      ah,al             ; and save it in AH
       or       al,3              ; Turn speaker on
       out      61H,al
skippy:
hold:  mov      cx, 2801
spkr_on: loop   spkr_on
       dec      bx                ; Speaker-on count expired?
       jnz      hold              ; If not, keep speaker on
       mov      al,ah             ; Otherwise, recover value of port
       out      61H,al
done:  
       POP      DI
       mov      sp,bp             ; Restore locals from stack.
       pop      bp                ; Restore caller's bp
       ret                        ; Return to caller

ifdef Microsoft
_n_sound	endp
else
n_sound	endp
endif

;/***************************************************************/
;
;  Find the column position of the cursor.
;  Must be preceded by a n_row call!!!!
;  Will work when these routines already know the cursor position
;
ifdef Microsoft
_n_col	proc	far
else
n_col	proc	far
endif
		xor		ah,ah
		mov		al,col				; return col location
		ret
ifdef Microsoft
_n_col	endp
else
n_col	endp
endif

;/***************************************************************/
;  n_clear
;  Clear what we think is the current window
;
ifdef Microsoft
_n_clear	proc	far
else
n_clear	proc	far
endif
		push bp
		mov		al,0				; clear window
		mov		ah,6				; scroll up function
		mov		ch,topl				; top row to clear
		mov		cl,leftc			; left column
		mov		dh,_botl				; bottom row to clear
		mov		dl,_cols			; right side to clear
		mov		bh,_att				; attribute to use for blanks
		int		10h					; call BIOS
		pop bp
		ret
ifdef Microsoft
_n_clear	endp
else
n_clear	endp
endif


;/***************************************************************/
;  n_upscroll
;  Scroll up what we think is the current window, n lines
;
ifdef Microsoft
_n_upscroll	proc	far
else
n_upscro	proc	far
endif
		push	bp
		mov		bp,sp
		mov		al,[bp+x]			; number of lines to scroll
		mov		ah,6				; scroll up function
		mov		ch,topl				; top row to clear
		mov		cl,leftc			; left column
		mov		dh,_botl				; bottom row to clear
		mov		dl,rightc			; right side to clear
		mov		bh,_att				; attribute to use
		int		10h					; call BIOS
		pop		bp
		ret
ifdef Microsoft
_n_upscroll	endp
else
n_upscro	endp
endif

;/***************************************************************/
;  n_dnscroll
;  Scroll up what we think is the current window, n lines
;
ifdef Microsoft
_n_dnscroll	proc	far
else
n_dnscro	proc	far
endif
		push	bp
		mov		bp,sp
		mov		al,[bp+x]			; number of lines to scroll
		mov		ah,7				; scroll down function
		mov		ch,topl				; top row to clear
		mov		cl,leftc			; left column
		mov		dh,_botl				; bottom row to clear
		mov		dl,rightc			; right side to clear
		mov		bh,_att				; attribute to use for blank lines
		int		10h					; call BIOS
		pop		bp
		ret
ifdef Microsoft
_n_dnscroll	endp
else
n_dnscro	endp
endif


;/***************************************************************/
;  n_putchar(letter)
;      puts onto screen at current cursor location
;
ifdef Microsoft
_n_putchar	proc	far
else
n_putcha	proc	far
endif
		push bp
        mov bp,sp
        mov al,[bp+x]   		; char to write
	    xor  bx,bx       		;  set page number for all cursor addresses

ifdef	TRASH
	    cmp  al,10           	; line feed
	    jnz nxt

		mov		al,row			; get current cursor row position
		cmp		al,_botl
		jl		noscr			; within window area

		mov		ax,1			; scroll up one line
		push	ax
ifdef Microsoft
		call	_n_upscroll		; scrolls it up one
else
		call	n_upscro		; scrolls it up one
endif
		pop		ax				; take parameter off of stack
;		mov		al,leftc		; get left side value
;		mov		col,al			; set cursor to left
		jmp		putcur

noscr:
;		mov		al,leftc		; return cursor to left side
;		mov		col,al
		inc		row
		jmp		putcur			; set new cursor position, return

nxt:
		cmp  al,7 				; ctrl-G, bell
	    jnz  nxt2
;
;  handle bell with a call to a special routine
;
	mov ax,12        ; duration of tone
	push ax
	mov ax,1000      ; frequency of tone
	push ax
ifdef Microsoft
	call _n_sound
else
	call n_sound
endif
	add sp,4         ; remove params from stack

here2:
		pop		bp
		ret

nxt2:
	    cmp		al,13           ; cr,  home the cursor
		jnz		trytab
		mov		al,leftc		; new cursor position
		mov		col,al
		jmp		putcur

trytab:
	    cmp  	al,9            ; tab character
	    jnz  notcrlf   			; ready for regular character

;  expand tabs
		mov		dl,col			; get cursor position
		mov		cl,3
		shr 	dl,cl			; divide cursor position by 8
		inc		dl				; increment cursor position
		shl		dl,cl			; multiply back by 8
		mov		col,dl

							; check to see if past right side
		mov		dl,col		; get where the cursor has moved to
		cmp		dl,rightc	; over the side yet?
		ja		tabover		; set the new position
		jmp		putcur

tabover:
		mov		dl,leftc
		mov		col,dl

		inc		row			; to next row
		mov		dl,row		; what row?
		cmp		dl,_botl
		jg		tabnos		; we are okay
		jmp		putcur

tabnos:
		dec		row			; need to scroll

		mov		ax,1
		push	ax
ifdef Microsoft
		call	_n_upscroll	; scroll window up one line
else
		call	n_upscro	; scroll window up one line
endif
		pop		ax
		mov		al,leftc	; reset cursor position to left
		mov		col,al
	    jmp  	putcur

notcrlf:
    	cmp  	al,8           ; backspace
	    jnz 	regchar

		mov		al,col			; where is cursor?
		cmp		al,leftc		; is at left of screen?
		jz		here2
		dec		col				; decrement cursor position
		jmp		putcur			; okay, move cursor where it belongs

regchar:
	    mov  cx,1h         		; number of repetitions = 1
   		mov  bl,_att 			; attribute of char
	    mov  ah,9         		; write char
   		int  10h

	    inc  	col             	; move cursor over one. 

		mov		dl,col			; get current position
    	cmp  	dl,rightc		; is at right side of screen?
	    jle   	putcur	 		; no, char can just be put out, cursor moved.

;
;  check word-wrap because we are at edge of window
;
		mov		dl,wrap
		or		dl,dl			; 0 = no wrap, 1 = wrap
		jz		nowrap

    	mov  	dl,leftc		; cursor will wrap around
		mov		col,dl			; save the new column position
		inc		row				; to next row
		mov		dl,_botl
	    cmp  	row,dl			; do we need to scroll?

	    jng  putcur				; no, okay for next row, normal wrap

; scroll screen up one 
		push	ax
		mov		ax,1
		push	ax
ifdef Microsoft
		call	_n_upscroll	; scroll window up one line
else
		call	n_upscro	; scroll window up one line
endif
		pop		ax
		pop		ax				; get the character back
		dec		row				; scrolled up one

		jmp		putcur			; don't wrap

nowrap:
		dec		col

putcur:
		mov		dh,row
		mov		dl,col
    	mov  	ah,2h
    	xor 	bx,bx
	    int  	10h             ; set cursor position

escapehere:
else
       		push	si
		push	di
		push	es
		mov	ax, ss
		mov	es, ax
		lea	bp, [bp+x]
		mov	dh, row
		mov	dl, col
		mov	bl, _att
		mov	bh, 0
		mov	cx, 1
;		mov	ax, 01301H
;		int	10H
		call	_n_write_string
		mov	AX,0300H
		xor	bx,bx
		int	10H
		mov	row, dh
		mov	col, dl
		pop	es
		pop	di
		pop	si
endif

    pop bp
    ret


ifdef Microsoft
_n_putchar	endp
else
n_putcha	endp
endif

;/**********************************************************************/
;  draw
;  place characters on the screen-- checking for bounds, etc.  all done
;  at a higher level.
;
;  n_draw(s,len)
;    char*s ; int len;
;
ifdef Microsoft
_n_draw proc far
else
n_draw proc far
endif
	push bp
	mov bp,sp
	push es
        push    si
        push    di
;
;  for now, assume that the cursor location has already been set
;  (cursor is there)
;
	mov	si,[bp+x]				; pointer to string
	mov	ax,[bp+x+2]				; ds of string
	mov es,ax
	mov	di,[bp+x+4]				; # of characters
	mov	dh,row					; row where cursor is

loopdraw:
	mov	al,es:[si]				; get character to write from es:si
	inc	si
    mov  cx,1h           		; number of repetitions = 1
	xor  bh,bh					; display page 0
   	mov  bl,_att 				; attribute of char
    mov  ah,9           		; write char
   	int  10h

	inc	col						; move the cursor over
	mov		dl,col
   	mov  	ah,2h
	xor		bx,bx
    int  	10h             	; set cursor position

	dec di						; check counter
	jnz loopdraw				; go through to required count

        pop     di
        pop     si
	pop es
	pop	bp
	ret
ifdef Microsoft
_n_draw endp
else
n_draw endp
endif

;/**********************************************************************/
;  cheat
;  put characters on the screen as per n_draw, but write directly
;  to display memory.  Don't even check for retrace
;
ifdef Microsoft
_n_cheat proc	far
else
n_cheat proc	far
endif
	push bp
	mov bp,sp
	push es
	push ds
        push    di
        push    si
;
;  for now, assume that the cursor location has already been set
;  (cursor is there)
;
	mov	ax,_regen
	mov	es,ax					; set up for segment where screen is

	mov	al,row					; row where chars go
	xor	ah,ah
	xor	bx,bx
	mov	bl, _cols				; number of columns on screen
	shl	bx,1 					; correct for attributes
	mul	bx					; ax now equals start of row
	xor	bh,bh
	mov	bl,col
	shl	bx,1					; col*2
	add	ax,bx					; add in column offset
	add	ax,topoff				; add in topview offset if there is one
	mov	di,ax					; store in di (es:di)
	push	di
	mov	cx,[bp+x+4]				; # of characters
	push	cx
	add	col,cl					; column position of cursor
	mov	ah,_att					; attribute for chars
	mov	si,[bp+x]				; pointer to string
	mov	bx,[bp+x+2]				; ds of string
	mov ds,bx
;
;  do the move
;
	cld
lpcheat:
	lodsb						; get next byte
	stosw						; store byte and attribute
	loop lpcheat

	pop	cx
	pop	di
	pop	si
	pop	di
	pop	ds
	cmp	_dotop,1
	jne	K101
     	mov	ah, 0ffH	;; what does topview need, possible bug!!!
	int	10H
K101:
;        pop     si
;        pop     di
;	pop	ds
	pop	es
	pop	bp
	ret

ifdef Microsoft
_n_cheat	endp
else
n_cheat	endp
endif

;/**********************************************************************/
;
;  keyboard handling

;    the interrupt and codes for the keyboard interface.

keyboard    equ    16h        ;interrupt 16 to deal with keyboard



;**********************************************************************
;
;  get a translated character from the keyboard.
;  Why hasn't someone else written this first?
;  Tim Krauskopf
;


ifdef Microsoft
_n_getchar	proc	far
else
n_getcha	proc	far
endif

ifdef NEWKEY
        push  	bp
kbint	equ	16h			; IBM, Bios keyboard interrupt
shift	equ	200h			; IBM, synonym for right or left shift
control	equ	400h			; IBM, synonym for control shift
alt	equ	800h			; IBM, synonym for alt shift
enhanced equ	1000h			; IBM, enhanced keyboard code

rgt_shift equ	1			; IBM shift state bits
lft_shift equ	2
ctl_shift equ	4
alt_shift equ	8
numlock	  equ	20h


getky6:					; full BIOS keyboard reading
	xor	ax,ax
	mov	keycode,ax
	test	byte ptr _kbcodes,80h	; kbcodes initiated?		[dan]
	jz	getky6a			; z = yes			[dan]
	mov	_kbcodes,0001h		; low byte = status, high = read char
	push	cx			; save registers
	push	es
	mov	cx,40h			; segment 40h
	mov	es,cx
	xor	cx,cx
	mov	cl,byte ptr es:[96h]	; kbd_flag_3, Enhanced keyboard area
	and	cl,10h			; select Enhanced kbd presence bit
	mov	_extended, cx		; save a copy of extended flag
	mov	ch,cl			; copy, for both status and read
	or	_kbcodes,cx		; 0 = regular kbd, 10h = enhanced kbd
	pop	es
	pop	cx
getky6a:
ifndef	junk
	mov	ah,byte ptr _kbcodes	; anything at keyboard?
	xor	al,al
	int	kbint			; Bios keyboard interrupt
	jnz	getky1			; nz = char available
	cmp	al,240			; Bios "special ascii code" 0f0h?
	je	getky1			; e = yes, Bios makes error, is a key
	mov	ax,-1
	mov	keycode,ax
	jmp	out2
;;	ret	 			; exit on no char available
endif
getky1:	mov	ah,byte ptr _kbcodes+1	; read, no echo, wait til done
	int	kbint			; ==> ah = scan code, al = char value
	cmp	ah,0			; keycode entered by ALT ###?
	je	getky1c			; e = yes, not enhanced
	cmp	ah,0e0h			; Enhanced kbd Enter, fwd slash keys?
	jne	getky1b			; ne = no
	xchg	ah,al			; interchange scan and ascii fields
getky1b:cmp	al,0E0h			; enhanced key hidden code?
	jne	getky1c			; ne = no
	mov	byte ptr keycode,ah	; retain scan code, supress 0e0h
	or	keycode,scan+enhanced	; set scan and enhanced idents
	mov	ah, byte ptr _kbcodes	; use regular keyboard op code here
	inc	ah
	int	kbint			; get current shift state
	mov	bl,al			; copy for a moment
	and	bl,rgt_shift		; mask out all but right shift
	shl	bl,1			; move right shift to left shift pos
	or	al,bl			; collapse shift bits
	and	al,(lft_shift + alt_shift + ctl_shift)
	or	byte ptr keycode+1,al	; store in type field of keycode
	clc				; say have a keystroke
	jmp	getkyx			; Enhanced kbd end. Skip other tests

getky1c:
;ifdef	junk
	push	cx
	mov	cx,aliaslen		; number of aliased keys
	or	cx,cx
	pop	cx
	jz	getky2			; z = none
	push	di			; check key (ax) for aliases
	push	cx
	push	es
	push	ds
	pop	es			; make es:di refer to data segment
	mov	di,offset DGROUP:aliaskey	; list of aliased keys
	mov	cx,aliaslen		; number of entries
	cld
	repne	scasw			; look for a match
	pop	es
	pop	cx
	pop	di
	jne	getky2			; ne = not there
	mov	al,0			; force use of scan code (in ah)
;endif
getky2:	or	al,al			; scan code being returned?
	jnz	getky3			; nz = no
	mov	byte ptr keycode,ah	; store scan code for gsh
	push	ax
	push	bx
	call	gsh			; get modified shift state
	or	byte ptr keycode+1,al	; store in type field of keycode
	pop	bx
	pop	ax
	xchg	ah,al			; put scan code in al
	or	keycode,scan		; set scan flag (vs ascii)
getky3:	mov	byte ptr keycode,al	; return key's code (usually ascii)
	clc				; carry clear = got a char
getkyx:	
	
else
	               		;return the next character pressed
    	                ; translate if necessary
        push  	bp
        mov    	ah,ds:getc    ;ask for a keyboard character
        int    	keyboard
        cmp     al,0e0H
        je      ext             ; if al == e0 then extended cursor keys
        or		al,al
        jnz    	notextend		; is it an extended char?
ext:
ifdef junk
        push    ax
        mov     bp,sp
        push    ax
        push    ds
        mov     ax,offset dgroup:printme
        push    ax
        push    ds
        mov     ax, offset dgroup:buffer
        push    ax
        call    _sprintf
        mov     sp,bp
        push    cx
        push    es
        push    si
        push    di
        mov     cx,4
        mov     si, offset dgroup:buffer
        xor     di,di
        mov     ax, 0b800H
        mov     es,ax
loop1:
        lodsb
        stosb
        inc     di
        loop  loop1
        pop     di
        pop     si
        pop     es
        pop     cx
        pop     ax
endif                       
        mov    bx,offset dgroup:tr		; convert special key
		mov		al,ah
		xlatb					; translate through table
        cmp     al,0
        jne     notextend
        mov     ax,-1
        jmp     short hithere
notextend:
	    mov    ah,0			; char returns in al
hithere:
endif
out2:
ifdef	NEWKEY
	mov	ax, keycode
endif
        pop    bp
        ret
ifdef Microsoft
_n_getchar	endp
else
n_getcha	endp
endif
ifdef	NEWKEY
; get shift state into al.  We care about only shift, ctl, and alt keys.
; right shift is collapsed into left shift. NumLock offsets Shift on keypad
; white keys.
gsh	proc	near
	mov	ah,byte ptr _kbcodes
	inc	ah
	int	kbint			; get current shift state
	mov	bl,al			; copy for a moment
	and	bl,rgt_shift		; mask out all but right shift
	shl	bl,1			; move right shift to left shift pos
	or	al,bl			; collapse shift bits
	cmp	byte ptr keycode,71	; below numeric key pad?
	jb	gsh1			; b = yes
	cmp	byte ptr keycode,83	; above numeric key pad?
	ja	gsh1			; a = yes
	cmp	byte ptr keycode,74	; grey - key ?
	je	gsh1			; e = yes
	cmp	byte ptr keycode,78	; grey + key
	je	gsh1			; e = yes
	test	al,numlock		; numlock set?
	jz	gsh1			; z = no
	xor	al,lft_shift		; numlock offsets shift and vice versa
gsh1:	and	al,(lft_shift + alt_shift + ctl_shift)
	ret
gsh	endp

endif

;**********************************************************************
;  Check for character present at the keyboard
;  If there is one available, return it, if not, return -1
;
;  translate any extended characters
;
ifdef Microsoft
;_n_chkchar	proc	far
begin n_chkchar
else
n_chkcha	proc	far
endif
        push    bp
ifndef	NEWKEY
        mov    ah, byte ptr _kbcodes
        int    keyboard
        mov    ax,-1
        jz    	nokey
endif
ifdef Microsoft
        call    _n_getchar        ;get the coded character
else
        call    n_getcha        ;get the coded character
endif
	cmp	ax, 11cH
	jne	n1
	mov	ax, 13
	jmp	nokey
n1:
;	cmp	ax, 10eH
;	jne	n2
;	mov	ax, 8
;	jmp	nokey
n2:
	cmp	ax, 10fH
	jne	nokey
	mov	ax, 9
nokey:
    	pop    bp
        ret
ifdef Microsoft
_n_chkchar	endp
else
n_chkcha	endp
endif

ifdef Microsoft
_n_chkstat	proc	far
else
n_chkstat	proc	far
endif
        push    bp
        mov    ah,byte ptr _kbcodes
	inc	ah
	xor	al,al
        int    keyboard
    	pop    bp
        ret
ifdef Microsoft
_n_chkstat	endp
else
n_chkstat	endp
endif



;/***************************************************************/
;  savewin
;    copy the current window into a buffer
;
;   usage:  n_savewindow(buffer);
;
ifdef Microsoft
_n_savewin	proc	far
else
n_savewi	proc	far
endif
		push	bp
		mov		bp,sp
		push	es
		push	ds
                push    di
                push    si
		mov		ax,[bp+x+2]			; ds of buffer
		mov		es,ax
			mov		di,[bp+x]			; pointer to buffer
		cld
;
;  store parameters in first, for recall later
;
		mov		al,row				; cursor position: row,col
		stosb
		mov		al,col
		stosb
		mov		al,topl				; window boundaries
		stosb
		mov		al,leftc
		stosb
		mov		al,_botl
		stosb
		mov		al,rightc
		stosb						; store in buffer too
;
;  calculate amount to move
;
;
;  calculate number of lines to move
;
        mov  al,topl              ; x1
		mov  bl,_botl				; x2
		sub  bl,al                  ; x2 = x2-x1
        inc  bl                     ; add 1 line
		mov  [bp+x],bl				; keep it somewhere safe
;
;  calculate screen offset  = 160*x1+2*y1;
;
;   al has topl in it
		xor  ah,ah
        mov  bl,160
        mul  bl					; how many chars in x1 lines, in ax
		xor  ch,ch
        mov  cl,leftc           ; chars to left side
        shl  cl,1               ; *2 counts attributes
        add  ax,cx              ; add them
        mov  si,ax           	; place into source index
;
;  find number of characters to move each time
;
		mov  cl,rightc
        sub  cl,leftc        ; y2 = y2-y1
        inc  cl              ;  add 1
		mov  [bp+x+1],cl		; safe place again
;
;  find number to add to wrap around for each line
;
        mov  bl,cl           ; # of chars moved each time
        shl  bl,1            ; chars*2
        mov  al,160
        sub  al,bl           ; 160-chars*2
		mov  [bp+x+2],al     ; safe place to keep it
;
;
        mov  ax,_regen        ; where source segment is (screen)
        mov  ds,ax

        mov  dx,03dah             ; color card status port
		xor  bh,bh
        mov  bl,[bp+x]           ; howmany lines to move

        cmp  ax,0b000h            ; check for mono card
        jnz getline
        mov  dx,03bah             ; change status port value
getline:
        mov  cl,[bp+x+1]           ; # of chars to move
getchar:
;        in   al,dx                ; get status byte
;        test al,1                 ; horizontal retrace
;        jnz  getchar              ; not there yet
;ison:   in   al,dx
;        test al,1
;        jz   ison                 ; still on, try again
        movsw                     ; now is time, move the word
        loop getchar              ; do another until this line is done
;
        dec bx
        jz  endkeep               ; done, we are out of here
		mov	al,[bp+x+2]
		xor	ah,ah
        add si,ax                 ; go to next line, skip 160-n*2 bytes
        jmp getline

endkeep:
        pop     si
        pop     di
        pop  ds
        pop  es
        pop  bp
        ret

ifdef Microsoft
_n_savewin	endp
else
n_savewi	endp
endif


;/***************************************************************/
;  restwindow
;    restore the contents of the window to the screen
;
ifdef Microsoft
_n_restwin	proc	far
else
n_restwi	proc	far
endif
		push	bp
		mov		bp,sp
		push	es
		push	ds
                push    si
                push    di
		mov		ax,[bp+x+2]			; ds of buffer
		push	ax					; will pop to ds later 
		mov		es,ax				; used to restore variable values
		mov		si,[bp+x]			; pointer to buffer
		cld
;
;  get back stored variables
;
		mov		al,es:[si]			; get cursor row
		mov		row,al
		inc		si
		mov		al,es:[si]
		mov		col,al
		inc		si
		mov		al,es:[si]			; window boundaries
		mov		topl,al
		inc		si
		mov		al,es:[si]
		mov		leftc,al
		inc		si
		mov		al,es:[si]
		mov		_botl,al
		inc		si
		mov		al,es:[si]
		mov		rightc,al
		inc		si					; now we are ready for data

;
;  calculate amount to move
;
;
;  calculate number of lines to move
;
        mov  al,topl              ; x1
		mov  bl,_botl				; x2
		sub  bl,al                  ; x2 = x2-x1
        inc  bl                     ; add 1 line
		mov  [bp+x],bl				; keep it somewhere safe
;
;  calculate screen offset  = 160*x1+2*y1;
;
;   al has topl in it
		xor  ah,ah
        mov  bl,160
        mul  bl					; how many chars in x1 lines, in ax
		xor  ch,ch
        mov  cl,leftc           ; chars to left side
        shl  cl,1               ; *2 counts attributes
        add  ax,cx              ; add them
        mov  di,ax           	; place into source index
;
;  find number of characters to move each time
;
		mov  cl,rightc
        sub  cl,leftc        ; y2 = y2-y1
        inc  cl              ;  add 1
		mov  [bp+x+1],cl		; safe place again
;
;  find number to add to wrap around for each line
;
        mov  bl,cl           ; # of chars moved each time
        shl  bl,1            ; chars*2
        mov  al,160
        sub  al,bl           ; 160-chars*2
		mov  [bp+x+2],al     ; safe place to keep it
;
;
        mov  ax,_regen        ; screen will receive this data
        mov  es,ax
		pop  ds				; set ds to where data is coming from 

        mov  dx,03dah             ; color card status port
		xor  bh,bh
        mov  bl,[bp+x]           ; howmany lines to move

        cmp  ax,0b000h            ; check for mono card
        jnz rgetline
        mov  dx,03bah             ; change status port value
rgetline:
        mov  cl,[bp+x+1]           ; # of chars to move
rgetchar:
;        in   al,dx                ; get status byte
;        test al,1                 ; horizontal retrace
;        jnz  rgetchar              ; not there yet
;rison:   in   al,dx
;        test al,1
;        jz   rison                 ; still on, try again
        movsw                     ; now is time, move the word
        loop rgetchar              ; do another until this line is done
;
        dec bx
        jz  rendkeep               ; done, we are out of here
		mov	al,[bp+x+2]
		xor	ah,ah
        add di,ax                 ; go to next line, skip 160-n*2 bytes
        jmp rgetline

rendkeep:
        pop     di
        pop     si
        pop  ds

		mov		dh,row				; load stored cursor position
		mov		dl,col
    	mov  	ah,2h
    	xor 	bx,bx
	    int  	10h             ; set cursor position to saved value

        pop  es
        pop  bp
        ret

ifdef Microsoft
_n_restwin	endp
else
n_restwi	endp
endif

;************************************************************************
;  n_puts
;  Window-compatible puts, uses n_putchar and also translates
;  \n to CRLF
;
;     usage:  identical to puts()
;
ifdef Microsoft
;_n_puts	proc	far
begin n_puts
else
n_puts	proc	far
endif
		push	bp
		mov		bp,sp
ifdef	TRASH
nextc:
		push	ds
		mov		dx,[bp+x+2]			; ds of string
		mov		ds,dx
		mov		bx,[bp+x]			; ptr to string
		mov		al,[bx]				; get character
		xor		ah,ah				; clear ah
		pop		ds
		or		al,al				; is it end of string?
		jz		donest

		inc		word ptr [bp+x]		; increment pointer for next one

		cmp		al,10				; newline?
		jnz		dochar
		mov		al,13
		push	ax
ifdef Microsoft
		call	_n_putchar
else
		call	n_putcha
endif
		pop		ax
		mov		ax,10
dochar:
		push	ax
ifdef Microsoft
		call	_n_putchar
else
		call	n_putcha
endif
		pop		ax					; take off of the stack
		jmp		nextc

donest:
		mov		ax,13				; CR
		push	ax
ifdef Microsoft
		call	_n_putchar
else
		call	n_putcha
endif
		pop		ax
		mov		ax,10				; LF
		push	ax
ifdef Microsoft
		call	_n_putchar
else
		call	n_putcha
endif
		pop		ax
else
		push	si
		push	di
		pushf
		push	es
		cld		
		les	bp, [bp+x]
		mov	si,bp
		xor	cx,cx
loopp:
		inc	cx
		lodsb
		cmp	al, 0
		jne	loopp
		dec	cx

		mov	dh, row
		mov	dl, col
		mov	bl, _att
		mov	bh, 0
;		mov	ax, 01301H
;		int	10H
		call	_n_write_string
		mov	AX,0300H
		xor	bx,bx
		int	10H
		mov	row, dh
		mov	col, dl

		pop	es
		popf
ifdef	NOPAC
		mov	ax, 13
		push	ax
		call	_n_putchar
		pop	ax
		mov	ax, 10
		push	ax
		call	_n_putchar
		pop	ax
endif
		pop	di
		pop	si
endif
		pop		bp
		ret
ifdef Microsoft
_n_puts	endp
else
n_puts	endp
endif




ifdef Microsoft
;_n_bioswrite	proc	far
begin n_bioswrite
else
n_bioswrite	proc	far
endif
		push	bp
		mov		bp,sp
		push	si
		push	di
		pushf
		push	es
		cld		
		les	bp, [bp+x]
		mov	si,bp
rescan:;
		xor	cx,cx
loopp2:
		inc	cx
		db 26H		; seg es  masm sucks
		lodsb	
		cmp	al, 0
		jne	check_bell

		; do something here w/ end of string
		jmp	special;
check_bell:
		cmp	al,7
		jne	check_cr
		; cr here
		jmp	special
check_cr:
		cmp al,13
		jne	check_lf
		; lf here
		jmp	special
check_lf:
		cmp al,10
		jne loopp2
		; lf here

special:;
		push	ax
		dec	cx
		cmp	cx,0
		je	skipme;

		mov	dh, row
		mov	dl, col
		mov	bl, _att
		mov	bh, 0
;		mov	ax, 01301H
		push	bp
;		int	10H
		call	_n_write_string
		mov	AX,0300H
		xor	bx,bx
		int	10H
		mov	row, dh
		mov	col, dl
		pop	bp
;	
skipme:;
		pop	ax
		cmp	al,0
		je	byebye
		; we need to put in some special delay hack here.
		
		mov	ah,0eH
		xor	bh,bh
		int	10H		; display special character
		mov	AX,0300H
		xor	bx,bx
		int	10H
		mov	row, dh
		mov	col, dl

		mov	bp,si
		jmp	rescan;

byebye:;
		pop	es
		popf

		pop	di
		pop	si
		pop		bp
		ret
ifdef Microsoft
_n_bioswrite	endp
else
n_bioswrite	endp
endif


;**********************************************************************
;
;  find first
;    make dos find file names according to wildcards
;  n_findfirst(filename,attr)
;	char *filename; int attr;
;
ifdef Microsoft
_n_findfirst	proc	far
else
n_findfi	proc	far
endif
	push	bp
	mov		bp,sp
	push	es
	push	ds
	mov		ah,02fh					; DOS function get DTA
	int		21h
ifdef Microsoft
	mov		_dtaptr,bx				; squirrel a copy for me
	mov		ax,es
	mov		_dtads,ax
else
	mov		dtaptr,bx				; squirrel a copy for me
	mov		ax,es
	mov		dtads,ax
endif

	mov		ax,[bp+x+2]				; ds of filename ptr
	mov		ds,ax
	mov		dx,[bp+x]				; ptr part of filename
	mov		cx,[bp+x+4]				; attribute to search for
	mov		ah,04eh					; find matching file DOS call
	int		21h
	jc		badret					; ax already contains error code
	xor		ax,ax

badret:
	pop		ds
	pop		es
	pop		bp
	ret
ifdef Microsoft
_n_findfirst	endp
else
n_findfi	endp
endif
;
;  n_findnext()
;  will find entries that follow findfirst
;  no need to respecify file name
;
ifdef Microsoft
_n_findnext	proc	far
else
n_findne	proc	far
endif
	push	bp
	mov		ah,04fh					; find next DOS call
	int		21h
	jc		nbadret
	xor		ax,ax

nbadret:
	pop		bp
	ret
ifdef Microsoft
_n_findnext	endp
else
n_findne	endp
endif

;
;  get the number of timer clicks from BIOS
;
ifdef Microsoft
;_n_clicks  proc	far            ; must be declared long n_clicks()
begin n_clicks
else
n_clicks  proc	far            ; must be declared long n_clicks()
endif
	mov		ah,0
	int		1ah
ifdef Microsoft
	mov		ax,dx				; MSC uses AX-lo, DX-hi
	mov		dx,cx              ; return values from interrupt 1A
else
	mov		ax,cx				; Lattice uses AX-hi, BX-lo
	mov		bx,dx				; Lattice returns in BX, MSC in DX and switched
endif
	ret
ifdef Microsoft
else
endif
ifdef Microsoft
_n_clicks endp
else
n_clicks endp
endif

ifdef Microsoft
_TEXT	ends
else
	endps
endif

	end

