/*
*  defines that are only applicable to the IBM PC/ PC-DOS environment
*  other files will take this one's place for other machines
*/


/*
*  hardware address for Ethernet broadcast address (used for ARP)
*/

#ifndef	PCDEFS_INCLUDE
#define	PCDEFS_INCLUDE	1
#ifdef	SMALL_PACKETS
#define RAWBUFF_LEN	 4096
#else
#define RAWBUFF_LEN     8192
#endif
#ifdef MASTERDEF
unsigned char bseed[] = {0xff,0xff,0xff,0xff,0xff,0xff};
#else
extern unsigned char bseed[],raw[];
#endif

/*
*  timing information is machine dependent
*/
#ifndef	MINITEL
long n_clicks();
#endif
#define movenbytes(A,B,C) movebytes((A),(B),(C))

/*
*  timeout for response to ARP packet for Ethernet
*/
/* was 15 */
#define DLAYTIMEOUT 4

/*
*  how often to poke a TCP connection to keep it alive and make
*  sure other side hasn't crashed. (poke) in 1/18ths sec
*  And, timeout interval
*/
#define POKEINTERVAL 3000
#define MAXRTO  100
#define MINRTO  1
#define ARPTO   20
#define CACHETO 7000
#define WAITTIME 35
#define LASTTIME 4000


#define CACHELEN 10
#define MAXSEG 1024
#define CREDIT 4096

#ifdef	MINITEL
#define	movebytes(d,s,n)	movmem(s,d,n)

#ifdef	JUNK
int far n_color(),n_upscroll(), n_dnscroll(),n_sound(),
			n_cheat(), n_clicks(), n_cur(), n_wrap(), n_erase(),
			n_getchar(), n_row(), n_col(), n_clear(), n_window(),
			n_putchar(), n_savewin(), n_restwin(), n_puts(),
			n_draw(), n_scrup(), n_scrdn(), n_scrlck(),
			n_chkstat();

unsigned int far	n_chkchar(),dbg();
#endif
int	n_puts(char far *s);
int 	ipcheck(void far *c,int n);
int 	tcpcheck(void far *c, void far *d, int n);

unsigned long 	longswap();


#endif
#endif
