/* $Id: HOSTFORM.H 1.9 1999/05/19 09:42:38 rwhitby Exp $ */
/* $Source: A:/SRC/TCP/NCSATCP/INCLUDE/RCS/HOSTFORM.H $ */

/*
 * Portions developed by the Educational Resources Center, Clarkson University.
 * Portions developed by the National Center for Supercomputing Applications,
 * University of Illinois at Urbana-Champaign.
 */

/*
*  Host and local machine configuration information.
*/

/*
*  Linked list of structures which describe other machines.
*  Arranged one per session with unique session names.
*/

struct machinfo {
  unsigned char
    *sname,                 /* pointer to name of session */
    *hname,                 /* pointer to name of that machine */
    *command,               /* initial command for rsh session */
    *keymap,                /* pointer to keymap file name */
    hostip[4],              /* IP number of this machine */
    gateway,                /* gateway preference, start with 1 */
    nameserv,               /* nameserver preference, start with 1 */
    bksp,                   /* backspace value */
    halfdup,                /* half duplex required */
    vtwrap,                 /* flag on when need wrap mode */
    vtmargin;               /* col to ring bell at */
  int
    clearsave,              /* whether to save cleared lines */
    mno,                    /* machine number for reference */
    mstat,                  /* status of this machine entry */
    bkscroll,               /* how many lines to save */
    domainsremaining,       /* how many domain search list entries remain */
    destport,               /* you can telnet to a different port than 23 */
    flags;                  /* general flags holder */              
#define MFLAGS_SCRIPT   0x80
  struct machinfo *next;    /* surprise, its a linked list! */
};

struct machinfo *Sgethost(),*Shostlook(),*Slooknum(),*Slookip(),*Smadd();

/*
 *  status fields for mstat, what do we know about that machine?
 */
#define NOIP 1		/* we don't have IP number */
#define UDPDOM 3	/* there is a UDP request pending on it */
/*  The next 20 numbers are reserved for UDPDOM */
#define HAVEIP 50	/* at least we have the # */
#define HFILE 70	/* we have IP number from host file */
#define DOM 71		/* we have an IP number from DOMAIN */

/* Configuration information which the calling program may want to
 * obtain from the hosts file.  The calling program should include
 * hostform.h and call Sgetconfig(cp) struct config *cp;
 * which will copy the information to the user's data structure. */

struct config {
  unsigned char
    netmask[4],         /* subnetting mask being used */
    havemask,           /* do we have a netmask? */
    myipnum[4],         /* what is my IP #? */
    hostname[32],       /* my hostname description (first 30 chars) */
    username[32],       /* my username description (first 30 chars) */
    ftp,                /* flag, enable ftp server */
    rcp,                /* flag, enable rcp server */
    color[3],           /* default colors to use */
    *termtype,          /* terminal type specification */
    *domainpath;        /* domain name search path */
    *capture,           /* pointer to where the capture file name is */
    *pass;              /* pointer to where the password file name is */
  int
    retrans,                /* initial retrans timeout */
    conto,                  /* time out in seconds to wait for connect */
    window,                 /* window, will be checked against buffers */
    maxseg,                 /* maximum receivable segment size */
    mtu,                    /* maximum transfer unit MTU (out) */
    domto,              /* time out for UDP domain request */
    ndom;               /* number of retries for domain requests */
  long sys_flags;
#define	SYS_FLAGS_VISUAL_BELL 0x1	/* use visual bell */

};

/* End of hostform.h */
