/*
  socklib.h -- Waterloo TCP socket libraries.
 
  Copyright (C) 1997-1999  Rod Whitby
  Copyright (C) 1992       Walter Andrew Nolan
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version
  2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be 
  useful, but WITHOUT ANY WARRANTY; without even the implied
  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
  PURPOSE.  See the GNU General Public License for more
  details.

  You should have received a copy of the GNU General Public
  License along with this program; if not, write to the Free
  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
  USA.

  $Source: A:/SRC/TCP/MTA/RCS/SOCKLIB.H $ 
  $Id: SOCKLIB.H 1.24 2000/04/09 07:02:50 rwhitby Exp $ 
*/ 
 
#ifdef _SOCKLIB_H_ 
 
#else 
 
#define _SOCKLIB_H_ 
 
#ifndef _WATTCP_TCP_H_INCLUDED_ 
 
#define _WATTCP_TCP_H_INCLUDED_ 
 
#include <stdio.h> 
 
#include <tcp.h> 
 
#endif 
 
/*---------------------------------------------------------------------- 
 -                                                                     < 
 -  Global Defines                                                     < 
 -                                                                     < 
/---------------------------------------------------------------------*/ 

#define SOCK_BUFFER_LEN 1000
#define MAX_PASSWORD 64

#define FTP_PORT 21
#define TELNET_PORT 23
#define SMTP_PORT 25
#define HTTP_PORT 80
#define POP_PORT 110
#define NNTP_PORT 119
#define IMAP_PORT 143

/*------------------------------------------------------------- 
 -                                                            < 
 -  Common variables & functions                              < 
 -                                                            < 
/------------------------------------------------------------*/ 
 
extern int WatTCP_initialized;

extern int Sock_debug;

extern char Sock_buffer[SOCK_BUFFER_LEN];
extern char Sock_last[SOCK_BUFFER_LEN];
extern int  Sock_echo;

void socklib_init(void); 
void socklib_debug(int debug); 
int socklib_url(char *url, char **protocol,
                char **host, int *port,
                char **user, char **pass,
                char **path); 
 
char *trim(char *str);
char *getaddress(char *str);
char *strrep(char *str, char old, char New);
int getnumbers(char *ascii, ...);
char *getnpass (char * prompt, char * buffer, int length);

int  socklib_wait_for(char *service, tcp_Socket *socket, int *status, char *match);
int  socklib_gets(char *service, tcp_Socket *socket, int *status);
void socklib_puts(char *service, tcp_Socket *socket);

int socklib_connect(char *service, tcp_Socket *socket, int *status, char *proxy, char *host, int port);

/*------------------------------------------------------------- 
 -                                                            < 
 -  IMAP variables & functions                                 < 
 -                                                            < 
/------------------------------------------------------------*/ 
 
tcp_Socket * imap_init(char *proxy, char *host, int port); 
 
int imap_login(tcp_Socket *imap_sock, char *userid, char *password); 
 
int imap_select(tcp_Socket *imap_sock, char *mailbox, long *count); 
 
int imap_search(tcp_Socket *imap_sock, char *criteria, char **result); 
 
long imap_length(tcp_Socket *imap_sock, long msg_num, long *size); 
 
int imap_retrieve(tcp_Socket *imap_sock, FILE *f, long msg_num, long body_lines, char eol);

int imap_delete(tcp_Socket *imap_sock, long msg_num); 
 
int imap_shutdown(tcp_Socket *imap_sock);
 
/*------------------------------------------------------------- 
 -                                                            < 
 -  POP variables & functions                                 < 
 -                                                            < 
/------------------------------------------------------------*/ 
 
tcp_Socket * pop_init(char *proxy, char *host, int port); 
 
int pop_login(tcp_Socket *pop_sock, char *userid, char *password); 
 
int pop_status(tcp_Socket *pop_sock, long *count, long *totlen); 
 
long pop_length(tcp_Socket *pop_sock, long msg_num, long *size); 
 
int pop_retrieve(tcp_Socket *pop_sock, FILE *f, long msg_num, long body_lines, char eol);

int pop_delete(tcp_Socket *pop_sock, long msg_num); 
 
int pop_shutdown(tcp_Socket *pop_sock); 
 
/*---------------------------------------------------------------------- 
 -                                                                     < 
 -  SMTP reply codes (from rfc821)                                     < 
 -  ------------------------------                                     < 
 -                                                                     < 
 -  SMTP_READY    220 <domain> Service ready                           < 
 -  SMTP_BYE      221 <domain> Service closing transmission channel    < 
 -  SMTP_OK       250 Requested mail action okay, completed            < 
 -  SMTP_GIMME    354 Start mail input; end with <CRLF>.<CRLF>         < 
 -  SMTP_OOPS     421 <domain> Service not available, closing          < 
 -                    transmission channel                             < 
 -                                                                     < 
/---------------------------------------------------------------------*/ 
 
/* Standard SMTP Replies */ 
 
#define SMTP_READY 220 
#define SMTP_BYE   221 
#define SMTP_OK    250 
#define SMTP_GIMME 354 
#define SMTP_OOPS  421 
 
/*------------------------------------------------------------- 
 -                                                            < 
 -  SMTP variables & functions                                < 
 -                                                            < 
/------------------------------------------------------------*/ 
 
tcp_Socket * smtp_init(char *proxy, char *host, int port, char * dom); 
 
char * smtp_parse_from_line(FILE *f); 
 
char ** smtp_parse_to_line(FILE *f); 
 
int smtp_send_MAIL_FROM_line (tcp_Socket *smtp_sock, FILE * f); 
 
int smtp_send_RCPT_TO_line (tcp_Socket *smtp_sock, FILE * f); 
 
int smtp_sendf(tcp_Socket *smtp_sock, FILE *f, char eol);
 
int smtp_shutdown(tcp_Socket *smtp_sock); 
 
/*---------------------------------------------------------------------- 
 -                                                                     < 
 -  NNTP reply codes (from rfc977)                                     < 
 -  ------------------------------                                     < 
 -                                                                     < 
 -  NNTP_READY    200 server ready - posting allowed                   < 
 -  NNTP_NOPOST   201 server ready - no posting allowed                <
 -  NNTP_BYE      205 closing connection - goodbye!                    < 
 -  NNTP_GROUP    211 n f l s group selected                           <
 -  NNTP_LIST     215 list of newsgroups follows                       <
 -  NNTP_ARTICLE  220 n <a> article retrieved                          <
 -  NNTP_HEAD     221 n <a> article retrieved - header only            <
 -  NNTP_BODY     222 n <a> article retrieved - body only              <
 -  NNTP_STAT     223 n <a> article retrieved - statistics only        <
 -  NNTP_OK       240 article posted ok                                < 
 -  NNTP_AUTHOK   281 authentication accepted                          < 
 -  NNTP_GIMME    340 send article to be posted                        < 
 -  NNTP_PASS     381 more authentication information required         < 
 -  NNTP_OOPS     400 service discontinued                             < 
 -  NNTP_NOGRP    411 no such news group                               <
 -  NNTP_NONUM    423 no such article number in this group             <
 -  NNTP_NOART    430 no such article found                            <
 -                                                                     < 
/---------------------------------------------------------------------*/ 
 
/* Standard NNTP Replies */ 
 
#define NNTP_READY   200 
#define NNTP_NOPOST  201
#define NNTP_BYE     205 
#define NNTP_GROUP   211
#define NNTP_LIST    215
#define NNTP_ARTICLE 220
#define NNTP_HEAD    221
#define NNTP_BODY    222
#define NNTP_STAT    223
#define NNTP_OK      240 
#define NNTP_AUTHOK  281
#define NNTP_GIMME   340 
#define NNTP_PASS    381
#define NNTP_OOPS    400 
#define NNTP_NOGRP   411
#define NNTP_NONUM   423
#define NNTP_NOART   430
 
/*------------------------------------------------------------- 
 -                                                            < 
 -  NNTP variables & functions                                < 
 -                                                            < 
/------------------------------------------------------------*/ 
 
tcp_Socket * nntp_init(char *proxy, char *host, int port); 
 
int nntp_auth(tcp_Socket *nntp_sock, char *username, char *password); 
 
int nntp_post(tcp_Socket *nntp_sock, FILE *f, char eol);
 
int nntp_list(tcp_Socket *nntp_sock, FILE *f);
 
int nntp_group(tcp_Socket *nntp_sock, char *group,
               long *count, long *first, long *last);
 
int nntp_stat(tcp_Socket *nntp_sock, long msg_num);
 
int nntp_article(tcp_Socket *nntp_sock, FILE *f, long msg_num,
                 long body_lines, char eol);
 
int nntp_shutdown(tcp_Socket *nntp_sock); 
 
/*------------------------------------------------------------- 
 -                                                            < 
 -  Global Macros                                             < 
 -                                                            < 
/------------------------------------------------------------*/ 
 
#define blankline(LINE) (strspn(LINE, " \n\t\r")==strlen(LINE))

#define SOCK_READ_ERR(PROTOCOL, SHUTDOWN) \
sock_err: \
  switch (PROTOCOL##_stat) { \
    case 1: /* foreign host closed */ \
      fprintf(stderr, "\n" #PROTOCOL "> Closed: %s\n", \
              sockerr(PROTOCOL##_sock)); \
      sock_abort(PROTOCOL##_sock); \
      SHUTDOWN; \
      return(0); \
    \
    case -1: /* timeout */ \
      fprintf(stderr, "\n" #PROTOCOL "> Timeout: %s\n", \
              sockerr(PROTOCOL##_sock)); \
      sock_abort(PROTOCOL##_sock); \
      SHUTDOWN; \
      return(0); \
  }

#define SOCK_WAIT_FOR(PROTOCOL, MATCH) \
  if (!socklib_wait_for(#PROTOCOL, PROTOCOL##_sock, &PROTOCOL##_stat, MATCH)) goto sock_err;

#define SOCK_GETS(PROTOCOL) \
  if (!socklib_gets(#PROTOCOL, PROTOCOL##_sock, &PROTOCOL##_stat)) goto sock_err;

#define SOCK_PUTS(PROTOCOL) \
  socklib_puts(#PROTOCOL, PROTOCOL##_sock);

#define SOCK_QUIT(PROTOCOL, SHUTDOWN) \
  fprintf(stderr, "\n" #PROTOCOL "> Quit: %s\n", \
          Sock_buffer); \
  sprintf(Sock_buffer, "QUIT"); \
  SOCK_PUTS(PROTOCOL); \
  SOCK_GETS(PROTOCOL); \
  sock_close(PROTOCOL##_sock); \
  SHUTDOWN; \
  return 0;

#define SOCK_QUIT_ON(PROTOCOL, NUM, SHUTDOWN) \
  if (atoi(Sock_buffer) == NUM) { \
    SOCK_QUIT(PROTOCOL, SHUTDOWN); \
  }

#define SOCK_QUIT_UNLESS(PROTOCOL, NUM, SHUTDOWN) \
  if (atoi(Sock_buffer) != NUM) { \
    SOCK_QUIT(PROTOCOL, SHUTDOWN); \
  }

#define SOCK_FAIL(PROTOCOL, SHUTDOWN) \
  fprintf(stderr, "\n" #PROTOCOL "> Fail: %s\n", \
          Sock_buffer); \
  SHUTDOWN; \
  return 0;

#define SOCK_FAIL_ON(PROTOCOL, NUM, SHUTDOWN) \
  if (atoi(Sock_buffer) == NUM) { \
    SOCK_FAIL(PROTOCOL, SHUTDOWN); \
  }

#define SOCK_FAIL_UNLESS(PROTOCOL, NUM, SHUTDOWN) \
  if (atoi(Sock_buffer) != NUM) { \
    SOCK_FAIL(PROTOCOL, SHUTDOWN); \
  }

#define SOCK_RSET(PROTOCOL, SHUTDOWN) \
  fprintf(stderr, "\n" #PROTOCOL "> Reset: %s\n", \
          Sock_buffer); \
  sprintf(Sock_buffer, "RSET"); \
  SOCK_PUTS(PROTOCOL); \
  SOCK_GETS(PROTOCOL); \
  SHUTDOWN; \
  return 0;

#define SOCK_RSET_ON(PROTOCOL, NUM, SHUTDOWN) \
  if (atoi(Sock_buffer) == NUM) { \
    SOCK_RSET(PROTOCOL, SHUTDOWN); \
  }

#define SOCK_RSET_UNLESS(PROTOCOL, NUM, SHUTDOWN) \
  if (atoi(Sock_buffer) != NUM) { \
    SOCK_RSET(PROTOCOL, SHUTDOWN); \
  }

#endif 
 
/* End of socklib.h */ 
