/*
  smtplib.c -- Waterloo TCP SMTP client libraries.

  Copyright (C) 1997-1999  Rod Whitby
  Copyright (C) 1992       Walter Andrew Nolan

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version
  2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be 
  useful, but WITHOUT ANY WARRANTY; without even the implied
  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
  PURPOSE.  See the GNU General Public License for more
  details.

  You should have received a copy of the GNU General Public
  License along with this program; if not, write to the Free
  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
  USA.

  $Source: A:/SRC/TCP/MTA/RCS/SMTPLIB.C $
  $Id: SMTPLIB.C 1.15 2000/04/09 07:02:50 rwhitby Exp $
*/

#include <conio.h>
#include <ctype.h>
#include <dos.h>
#include <mem.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "socklib.h"

/* Global Macros */

#define SMTP_PORT 25

/* Global Variables */

static int SMTP_stat;

/* General Stuff */

char * fix_quoted_commas(char * string)
{
  char * ptr;
  int quoted=0;

  ptr=string;

  while (*ptr!=0) {
    if (*ptr=='\"') quoted=(!quoted);
    if (*ptr==',' && quoted) *ptr='|';
    ptr=&ptr[1];
  }

  return(string);
}

/*-------------------------------------------------------------
 -                                                            <
 -  SMTP Stuff                                                <
 -                                                            <
/------------------------------------------------------------*/

#define SOCK_RESPONSE(PROTOCOL) \
  do { \
    SOCK_GETS(PROTOCOL); \
  } while (Sock_buffer[3] == '-')

#define SOCK_COMMAND(PROTOCOL) \
  strcpy(Sock_last, Sock_buffer); \
  SOCK_PUTS(PROTOCOL); \
  SOCK_GETS(PROTOCOL); \
  if (!strcmp(Sock_buffer, Sock_last)) { \
    Sock_echo = 1; \
    SOCK_GETS(PROTOCOL); \
  } \
  while (Sock_buffer[3] == '-') { \
    SOCK_GETS(PROTOCOL); \
  }

tcp_Socket * smtp_init(char *proxy, char *host, int port, char *dom)
{
  tcp_Socket *SMTP_sock=NULL;
  char *p;

  SMTP_sock=(tcp_Socket *)malloc(sizeof(tcp_Socket));

  if (!socklib_connect( "SMTP", SMTP_sock, &SMTP_stat, proxy, host, port)) {
    fprintf(stderr, "SMTP> Unable to connect to %s\n", host);
    return(0);
  }

  if (proxy) {
    if ((p = strstr(Sock_buffer, "220 ")) != NULL) {
      strcpy(Sock_buffer, p);
    }
    else {
      SOCK_RESPONSE( SMTP );
    }
  }
  else {
    SOCK_RESPONSE( SMTP );
  }

  SOCK_QUIT_UNLESS(SMTP, SMTP_READY, );
  
  sprintf(Sock_buffer, "HELO %s", dom);
  SOCK_COMMAND( SMTP );
  SOCK_QUIT_UNLESS(SMTP, SMTP_OK, );

  SOCK_READ_ERR(SMTP, );
  return SMTP_sock;
}

char * smtp_parse_from_line(FILE *f)
{
  int found=0, done=0;

  rewind(f);

  while (!feof(f) && !done) {
    if (!fgets(Sock_buffer, sizeof( Sock_buffer ), f)) break;
    if (*Sock_buffer=='\n') done=1;
    else if ((strncmpi(Sock_buffer,"from:",   5) == 0) ||
             (strncmpi(Sock_buffer,"sender:", 7) == 0)) {
      found=1; done=1;
    }
  }

  if (found) {
    return(strdup(getaddress(trim(strchr(Sock_buffer, ':')+1))));
  }
  return(0);
}

char ** smtp_parse_to_line(FILE *f)
{
  int done=0, current=0;
  char **list=NULL;
  char *addr;

  rewind(f);

  while(!feof(f) && !done) {
    if (!fgets(Sock_buffer, sizeof( Sock_buffer ), f)) break;
    if (*Sock_buffer=='\n') done=1;
    else if ((strncmpi(Sock_buffer,"to:",3)  == 0) ||
             (strncmpi(Sock_buffer,"cc:",3)  == 0) ||
             (strncmpi(Sock_buffer,"bcc:",4) == 0)) {
      fix_quoted_commas(Sock_buffer);
      addr=strtok(Sock_buffer,":");
      while ((addr=strtok(NULL,",\n")) != 0) {
        strrep(addr, '|', ',');
        list=(char **)realloc(list, sizeof(char *)*((current)+2));
        list[current]=strdup(getaddress(trim(addr)));
        list[current+1]=NULL;
        current++;
      }
    }
  }

  return(list);
}

int smtp_send_MAIL_FROM_line (tcp_Socket *SMTP_sock, FILE * f)
{
  char *from;

  from    = smtp_parse_from_line(f);

  sprintf( Sock_buffer, "MAIL FROM:<%s>", from);
  free(from);
  SOCK_COMMAND( SMTP );
  SOCK_QUIT_ON(SMTP, SMTP_OOPS, );
  SOCK_RSET_UNLESS(SMTP, SMTP_OK, );

  SOCK_READ_ERR(SMTP, );
  return(1);
}

#define FREE_ALL \
  for (i=0; to_list[i]!=NULL; i++) { \
    free(to_list[i]); \
  } \
  free(to_list);

int smtp_send_RCPT_TO_line (tcp_Socket *SMTP_sock, FILE * f)
{
  char **to_list;
  int i;

  to_list = smtp_parse_to_line(f);

  for (i=0; to_list[i]!=NULL; i++) {
    sprintf( Sock_buffer, "RCPT TO:<%s>", to_list[i]);
    SOCK_COMMAND( SMTP );
    SOCK_QUIT_ON(SMTP, SMTP_OOPS, FREE_ALL );
    SOCK_RSET_UNLESS(SMTP, SMTP_OK, FREE_ALL );
  }

  SOCK_READ_ERR(SMTP, FREE_ALL);

  FREE_ALL;

  return 1;
}

#undef FREE_ALL

int smtp_sendf(tcp_Socket *SMTP_sock, FILE *f, char eol)
{
  int in_header=1, in_bcc=0;
  char * temp;

  if (!smtp_send_MAIL_FROM_line(SMTP_sock, f)) return 0;
  if (!smtp_send_RCPT_TO_line(SMTP_sock, f)) return 0;

  rewind(f);

  sprintf(Sock_buffer, "DATA");
  SOCK_COMMAND( SMTP );
  SOCK_QUIT_ON(SMTP, SMTP_OOPS, );
  SOCK_RSET_UNLESS(SMTP, SMTP_GIMME, );

  while(!feof(f)) {
    if (!fgets(Sock_buffer, sizeof( Sock_buffer ), f)) break;
    strrep(Sock_buffer, '\n', '\0');
    strrep(Sock_buffer, '\r', '\0');

    trim(temp=strdup(Sock_buffer));
    if (strlen(temp)==0) in_header=0;
    free(temp);

    if (in_header && !in_bcc && strncmpi(Sock_buffer,"bcc:",4)==0) {
      in_bcc=1;
      continue;
    }

    if (in_bcc) in_bcc = isspace(*Sock_buffer);

    if (in_bcc) continue;

    if (*Sock_buffer=='.') {
      movmem(Sock_buffer, Sock_buffer+1, sizeof( Sock_buffer )-1 );
      *Sock_buffer='.';
    }

    if (in_header && eol) {
      if (!strncmp(Sock_buffer, "To:", 3)) {
        fprintf(stderr, "%s\n", Sock_buffer); clreol();
      }
      else if (!strncmp(Sock_buffer, "Subject:", 8)) {
        fprintf(stderr, "%s\n", Sock_buffer); clreol();
      }
    }

    SOCK_PUTS( SMTP );
    if (Sock_echo) SOCK_GETS( SMTP );
  }

  sprintf(Sock_buffer, ".");
  SOCK_COMMAND( SMTP );
  SOCK_QUIT_ON(SMTP, SMTP_OOPS, );
  SOCK_RSET_UNLESS(SMTP, SMTP_OK, );

  SOCK_READ_ERR(SMTP, );
  return 1;
}

int smtp_shutdown(tcp_Socket *SMTP_sock)
{
  if (sock_established(SMTP_sock)) {
    sprintf(Sock_buffer, "QUIT");
    SOCK_COMMAND( SMTP );
    sock_close( SMTP_sock );
  }
  else {
    sock_abort( SMTP_sock );
  }
  SOCK_READ_ERR(SMTP, sock_abort(SMTP_sock));
  return 1;
}

/* End of smtplib.c */
